/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.NCF;
import es.tid.pce.pcep.objects.LabelSet;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.util.Arrays;

public class BitmapLabelSet
extends LabelSet {
    private byte[] bytesBitmap;
    private int numLabels;
    private NCF ncf;

    public BitmapLabelSet() {
        this.setOT(1);
    }

    public BitmapLabelSet(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int numberBytes = this.getNumberBytes(this.numLabels);
        if (this.ncf != null) {
            try {
                this.ncf.encode();
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
        } else {
            this.ncf = new NCF();
            try {
                this.ncf.encode();
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
        }
        int size_bytes = 8 + this.ncf.getLength() + numberBytes;
        if (size_bytes % 4 != 0) {
            size_bytes += 4 - size_bytes % 4;
        }
        this.setObjectLength(size_bytes);
        this.object_bytes = new byte[size_bytes];
        this.encode_header();
        int offset = 4;
        int val = 4;
        this.object_bytes[offset + 1] = (byte)(this.numLabels >> 4 & 0xF | val << 4 & 0xF0);
        this.object_bytes[offset + 1] = (byte)(this.numLabels & 0xFF);
        System.arraycopy(this.ncf.getBytes(), 0, this.getBytes(), offset += 4, this.ncf.getLength());
        System.arraycopy(this.bytesBitmap, 0, this.getBytes(), offset += 4, numberBytes);
        for (int i = offset += numberBytes; i < size_bytes; ++i) {
            this.object_bytes[i] = 0;
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        int offset = 4;
        this.numLabels = (this.getBytes()[offset] & 0xF) << 8 | this.getBytes()[offset + 1] & 0xFF;
        this.ncf = new NCF(this.getBytes(), offset + 4);
        offset = offset + 4 + this.ncf.getLength();
        int numberBytes = this.getNumberBytes(this.numLabels);
        this.bytesBitmap = new byte[numberBytes];
        System.arraycopy(this.getBytes(), offset, this.bytesBitmap, 0, numberBytes);
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public void setNumLabels(int numLabels) {
        int numberBytes = this.getNumberBytes(numLabels);
        this.bytesBitmap = new byte[numberBytes];
        this.numLabels = numLabels;
    }

    public byte[] getBytesBitmap() {
        return this.bytesBitmap;
    }

    public void setBytesBitmap(byte[] bytesBitmap) {
        this.bytesBitmap = bytesBitmap;
    }

    public NCF getNcf() {
        return this.ncf;
    }

    public void setNcf(NCF ncf) {
        this.ncf = ncf;
    }

    public int getNumberBytes(int num) {
        int numberBytes = num / 8;
        if (numberBytes * 8 < num) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public String toString() {
        String ret = "";
        if (this.ncf != null) {
            ret = ret + "n base: " + String.valueOf(this.ncf.getN()) + " - ";
        }
        for (int i = 0; i < this.bytesBitmap.length; ++i) {
            ret = (this.bytesBitmap[i] & 0xFF) <= 15 ? ret + "0" + Integer.toHexString(this.bytesBitmap[i] & 0xFF) : ret + Integer.toHexString(this.bytesBitmap[i] & 0xFF);
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytesBitmap);
        result = 31 * result + (this.ncf == null ? 0 : this.ncf.hashCode());
        result = 31 * result + this.numLabels;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitmapLabelSet other = (BitmapLabelSet)obj;
        if (!Arrays.equals(this.bytesBitmap, other.bytesBitmap)) {
            return false;
        }
        if (this.ncf == null ? other.ncf != null : !this.ncf.equals(other.ncf)) {
            return false;
        }
        return this.numLabels == other.numLabels;
    }
}

