/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.SVECConstruct;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.PccReqId;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPRequest
extends PCEPMessage {
    private LinkedList<SVECConstruct> SvecList = new LinkedList();
    private LinkedList<Request> RequestList = new LinkedList();
    private Monitoring monitoring;
    private PccReqId pccReqId;
    private static final Logger log = LoggerFactory.getLogger("PCEPParser");

    public PCEPRequest() {
        this.setMessageType(3);
    }

    public PCEPRequest(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        if (this.RequestList.size() == 0) {
            log.warn("There should be at least one request in a PCEP Request message");
            throw new PCEPProtocolViolationException();
        }
        int len = 4;
        if (this.monitoring != null) {
            this.monitoring.encode();
            len += this.monitoring.getLength();
        }
        if (this.pccReqId != null) {
            this.pccReqId.encode();
            len += this.pccReqId.getLength();
        }
        for (i2 = 0; i2 < this.SvecList.size(); ++i2) {
            this.SvecList.get(i2).encode();
            len += this.SvecList.get(i2).getLength();
        }
        for (i2 = 0; i2 < this.RequestList.size(); ++i2) {
            this.RequestList.get(i2).encode();
            len += this.RequestList.get(i2).getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        if (this.monitoring != null) {
            System.arraycopy(this.monitoring.getBytes(), 0, this.messageBytes, offset, this.monitoring.getLength());
            offset += this.monitoring.getLength();
        }
        if (this.pccReqId != null) {
            System.arraycopy(this.pccReqId.getBytes(), 0, this.messageBytes, offset, this.pccReqId.getLength());
            offset += this.pccReqId.getLength();
        }
        for (i = 0; i < this.SvecList.size(); ++i) {
            System.arraycopy(this.SvecList.get(i).getBytes(), 0, this.messageBytes, offset, this.SvecList.get(i).getLength());
            offset += this.SvecList.get(i).getLength();
        }
        for (i = 0; i < this.RequestList.size(); ++i) {
            System.arraycopy(this.RequestList.get(i).getBytes(), 0, this.messageBytes, offset, this.RequestList.get(i).getLength());
            offset += this.RequestList.get(i).getLength();
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        byte[] bytes = this.messageBytes;
        int offset = 4;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 19) {
            try {
                this.monitoring = new Monitoring(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed Monitoring Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.monitoring.getLength();
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 20) {
            try {
                this.pccReqId = new PccReqId(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed PccReqId Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.pccReqId.getLength();
        }
        while (PCEPObject.getObjectClass(bytes, offset) == 11) {
            SVECConstruct c_svec;
            try {
                c_svec = new SVECConstruct(bytes, offset);
            }
            catch (PCEPProtocolViolationException e) {
                log.warn("Malformed SVEC Construct");
                throw new PCEPProtocolViolationException();
            }
            this.SvecList.add(c_svec);
            offset += c_svec.getLength();
        }
        while (PCEPObject.getObjectClass(bytes, offset) == 2) {
            Request req = new Request(bytes, offset);
            this.RequestList.add(req);
            if ((offset += req.getLength()) < bytes.length) continue;
            return;
        }
        if (this.RequestList.size() == 0) {
            throw new PCEPProtocolViolationException();
        }
    }

    public void addRequest(Request request) {
        this.RequestList.add(request);
    }

    public Request getRequest(int index) {
        return this.RequestList.get(index);
    }

    public LinkedList<Request> getRequestList() {
        return this.RequestList;
    }

    public void setRequestList(LinkedList<Request> requestList) {
        this.RequestList = requestList;
    }

    public LinkedList<SVECConstruct> getSvecList() {
        return this.SvecList;
    }

    public void setSvecList(LinkedList<SVECConstruct> svecList) {
        this.SvecList = svecList;
    }

    public void addSvec(SVECConstruct svec) {
        this.SvecList.add(svec);
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public PccReqId getPccReqId() {
        return this.pccReqId;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public void setPccReqId(PccReqId pccReqId) {
        this.pccReqId = pccReqId;
    }

    public String toString() {
        return "PCEPRequest [SvecList=" + this.SvecList + ", RequestList=" + this.RequestList + ", monitoring=" + this.monitoring + ", pccReqId=" + this.pccReqId + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.RequestList == null ? 0 : this.RequestList.hashCode());
        result = 31 * result + (this.SvecList == null ? 0 : this.SvecList.hashCode());
        result = 31 * result + (this.monitoring == null ? 0 : this.monitoring.hashCode());
        result = 31 * result + (this.pccReqId == null ? 0 : this.pccReqId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPRequest other = (PCEPRequest)obj;
        if (this.RequestList == null ? other.RequestList != null : !this.RequestList.equals(other.RequestList)) {
            return false;
        }
        if (this.SvecList == null ? other.SvecList != null : !this.SvecList.equals(other.SvecList)) {
            return false;
        }
        if (this.monitoring == null ? other.monitoring != null : !this.monitoring.equals(other.monitoring)) {
            return false;
        }
        return !(this.pccReqId == null ? other.pccReqId != null : !this.pccReqId.equals(other.pccReqId));
    }
}

