/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;

public class PCEPNotification
extends PCEPMessage {
    private LinkedList<Notify> notifyList;

    public PCEPNotification() {
        this.setMessageType(5);
        this.notifyList = new LinkedList();
    }

    public PCEPNotification(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.notifyList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        if (this.notifyList.size() == 0) {
            this.log.warn("There should be at least one notification in a PCEP Notification message");
            throw new PCEPProtocolViolationException();
        }
        int len = 4;
        for (int i = 0; i < this.notifyList.size(); ++i) {
            this.notifyList.get(i).encode();
            len += this.notifyList.get(i).getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        for (int i = 0; i < this.notifyList.size(); ++i) {
            System.arraycopy(this.notifyList.get(i).getBytes(), 0, this.messageBytes, offset, this.notifyList.get(i).getLength());
            offset += this.notifyList.get(i).getLength();
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        int offset = 4;
        if (offset >= this.getLength()) {
            this.log.warn("Empty notification message");
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(this.messageBytes, offset);
        while (oc == 2 || oc == 12) {
            Notify notf = new Notify(this.messageBytes, offset);
            this.notifyList.add(notf);
            if ((offset += notf.getLength()) >= this.getLength()) {
                return;
            }
            oc = PCEPObject.getObjectClass(this.messageBytes, offset);
        }
    }

    public Notify getNotify(int index) {
        return this.notifyList.get(index);
    }

    public void addNotify(Notify notify) {
        this.notifyList.add(notify);
    }

    public LinkedList<Notify> getNotifyList() {
        return this.notifyList;
    }

    public void setNotifyList(LinkedList<Notify> notifyList) {
        this.notifyList = notifyList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.notifyList == null ? 0 : this.notifyList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPNotification other = (PCEPNotification)obj;
        return !(this.notifyList == null ? other.notifyList != null : !this.notifyList.equals(other.notifyList));
    }
}

