/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.SVECConstruct;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.PccReqId;
import es.tid.pce.pcep.objects.PceId;
import es.tid.pce.pcep.objects.PceIdIPv4;
import java.util.LinkedList;

public class PCEPMonReq
extends PCEPMessage {
    private Monitoring monitoring;
    private PccReqId pccReqId;
    private LinkedList<PceId> pceList;
    private LinkedList<SVECConstruct> svecList;
    private LinkedList<Request> requestList;

    public PCEPMonReq() {
        this.setMessageType(8);
        this.monitoring = new Monitoring();
        this.pccReqId = new PccReqId();
        this.pceList = new LinkedList();
        this.svecList = new LinkedList();
        this.requestList = new LinkedList();
    }

    public PCEPMonReq(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.pceList = new LinkedList();
        this.svecList = new LinkedList();
        this.requestList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        if (this.monitoring == null || this.pccReqId == null) {
            this.log.warn("There should be at least one request in a PCEP Request message");
            throw new PCEPProtocolViolationException();
        }
        int len = 4;
        this.monitoring.encode();
        len += this.monitoring.getLength();
        this.pccReqId.encode();
        len += this.pccReqId.getLength();
        for (i2 = 0; i2 < this.svecList.size(); ++i2) {
            this.svecList.get(i2).encode();
            len += this.svecList.get(i2).getLength();
        }
        for (i2 = 0; i2 < this.requestList.size(); ++i2) {
            this.requestList.get(i2).encode();
            len += this.requestList.get(i2).getLength();
        }
        for (i2 = 0; i2 < this.pceList.size(); ++i2) {
            this.pceList.get(i2).encode();
            len += this.pceList.get(i2).getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.monitoring.getBytes(), 0, this.messageBytes, offset, this.monitoring.getLength());
        System.arraycopy(this.pccReqId.getBytes(), 0, this.messageBytes, offset += this.monitoring.getLength(), this.pccReqId.getLength());
        offset += this.pccReqId.getLength();
        for (i = 0; i < this.pceList.size(); ++i) {
            System.arraycopy(this.pceList.get(i).getBytes(), 0, this.messageBytes, offset, this.pceList.get(i).getLength());
            offset += this.pceList.get(i).getLength();
        }
        for (i = 0; i < this.svecList.size(); ++i) {
            System.arraycopy(this.svecList.get(i).getBytes(), 0, this.messageBytes, offset, this.svecList.get(i).getLength());
            offset += this.svecList.get(i).getLength();
        }
        for (i = 0; i < this.requestList.size(); ++i) {
            System.arraycopy(this.requestList.get(i).getBytes(), 0, this.messageBytes, offset, this.requestList.get(i).getLength());
            offset += this.requestList.get(i).getLength();
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        byte[] bytes = this.messageBytes;
        int offset = 4;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 19) {
            try {
                this.monitoring = new Monitoring(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                this.log.warn("Malformed Monitoring Object found");
                throw new PCEPProtocolViolationException();
            }
        } else {
            this.log.warn("Malformed PCEP Mon Request");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset += this.monitoring.getLength());
        if (oc == 20) {
            try {
                this.pccReqId = new PccReqId(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                this.log.warn("Malformed PccReqId Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.pccReqId.getLength();
        } else {
            this.log.warn("Malformed PCEP Mon Request");
            throw new PCEPProtocolViolationException();
        }
        while (PCEPObject.getObjectClass(bytes, offset) == 25) {
            try {
                PceIdIPv4 pceId = new PceIdIPv4(bytes, offset);
                this.pceList.add(pceId);
                offset += pceId.getLength();
            }
            catch (MalformedPCEPObjectException e) {
                e.printStackTrace();
            }
        }
        while (PCEPObject.getObjectClass(bytes, offset) == 11) {
            SVECConstruct c_svec;
            try {
                c_svec = new SVECConstruct(bytes, offset);
            }
            catch (PCEPProtocolViolationException e) {
                this.log.warn("Malformed SVEC Construct");
                throw new PCEPProtocolViolationException();
            }
            this.svecList.add(c_svec);
            offset += c_svec.getLength();
        }
        while (PCEPObject.getObjectClass(bytes, offset) == 2) {
            Request req = new Request(bytes, offset);
            this.requestList.add(req);
            offset += req.getLength();
        }
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public void setPccReqId(PccReqId pccReqId) {
        this.pccReqId = pccReqId;
    }

    public void addRequest(Request request) {
        this.requestList.add(request);
    }

    public void addSvec(SVECConstruct svec) {
        this.svecList.add(svec);
    }

    public void addPceId(PceId pce) {
        this.pceList.add(pce);
    }

    public Request getRequest(int index) {
        return this.requestList.get(index);
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public PccReqId getPccReqId() {
        return this.pccReqId;
    }

    public LinkedList<PceId> getPceList() {
        return this.pceList;
    }

    public void setPceList(LinkedList<PceId> pceList) {
        this.pceList = pceList;
    }

    public LinkedList<SVECConstruct> getSvecList() {
        return this.svecList;
    }

    public void setSvecList(LinkedList<SVECConstruct> svecList) {
        this.svecList = svecList;
    }

    public LinkedList<Request> getRequestList() {
        return this.requestList;
    }

    public void setRequestList(LinkedList<Request> requestList) {
        this.requestList = requestList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.monitoring == null ? 0 : this.monitoring.hashCode());
        result = 31 * result + (this.pccReqId == null ? 0 : this.pccReqId.hashCode());
        result = 31 * result + (this.pceList == null ? 0 : this.pceList.hashCode());
        result = 31 * result + (this.requestList == null ? 0 : this.requestList.hashCode());
        result = 31 * result + (this.svecList == null ? 0 : this.svecList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPMonReq other = (PCEPMonReq)obj;
        if (this.monitoring == null ? other.monitoring != null : !this.monitoring.equals(other.monitoring)) {
            return false;
        }
        if (this.pccReqId == null ? other.pccReqId != null : !this.pccReqId.equals(other.pccReqId)) {
            return false;
        }
        if (this.pceList == null ? other.pceList != null : !this.pceList.equals(other.pceList)) {
            return false;
        }
        if (this.requestList == null ? other.requestList != null : !this.requestList.equals(other.requestList)) {
            return false;
        }
        return !(this.svecList == null ? other.svecList != null : !this.svecList.equals(other.svecList));
    }
}

