/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.PccReqId;
import es.tid.pce.pcep.objects.RequestParameters;

public class PCEPMonRep
extends PCEPMessage {
    private Monitoring monitoring;
    private PccReqId pccReqId;
    private RequestParameters RP;

    public PCEPMonRep() {
        this.setMessageType(9);
        this.monitoring = new Monitoring();
        this.pccReqId = new PccReqId();
    }

    public PCEPMonRep(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 4;
        this.monitoring.encode();
        len += this.monitoring.getLength();
        this.pccReqId.encode();
        len += this.pccReqId.getLength();
        if (this.RP != null) {
            this.RP.encode();
            len += this.RP.getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[this.getLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.monitoring.getBytes(), 0, this.messageBytes, offset, this.monitoring.getLength());
        System.arraycopy(this.pccReqId.getBytes(), 0, this.messageBytes, offset += this.monitoring.getLength(), this.pccReqId.getLength());
        offset += this.pccReqId.getLength();
        if (this.RP != null) {
            System.arraycopy(this.RP.getBytes(), 0, this.messageBytes, offset, this.RP.getLength());
            offset += this.RP.getLength();
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        try {
            int offset = 4;
            int oc = PCEPObject.getObjectClass(this.getBytes(), offset);
            if (oc == 19) {
                this.monitoring = new Monitoring(this.getBytes(), offset);
                offset += this.monitoring.getLength();
            }
            if ((oc = PCEPObject.getObjectClass(this.getBytes(), offset)) == 20) {
                this.pccReqId = new PccReqId(this.getBytes(), offset);
                offset += this.pccReqId.getLength();
            }
            if ((oc = PCEPObject.getObjectClass(this.getBytes(), offset)) == 2) {
                this.RP = new RequestParameters(this.getBytes(), offset);
                offset += this.RP.getLength();
            }
        }
        catch (Exception e) {
            this.log.warn("Malformed Monitoring Object found");
            throw new PCEPProtocolViolationException();
        }
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public PccReqId getPccReqId() {
        return this.pccReqId;
    }

    public void setPccReqId(PccReqId pccReqId) {
        this.pccReqId = pccReqId;
    }

    public RequestParameters getRP() {
        return this.RP;
    }

    public void setRP(RequestParameters rP) {
        this.RP = rP;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.RP == null ? 0 : this.RP.hashCode());
        result = 31 * result + (this.monitoring == null ? 0 : this.monitoring.hashCode());
        result = 31 * result + (this.pccReqId == null ? 0 : this.pccReqId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPMonRep other = (PCEPMonRep)obj;
        if (this.RP == null ? other.RP != null : !this.RP.equals(other.RP)) {
            return false;
        }
        if (this.monitoring == null ? other.monitoring != null : !this.monitoring.equals(other.monitoring)) {
            return false;
        }
        return !(this.pccReqId == null ? other.pccReqId != null : !this.pccReqId.equals(other.pccReqId));
    }

    public String toString() {
        return "PCEPMonRep [monitoring=" + this.monitoring + ", pccReqId=" + this.pccReqId + ", RP=" + this.RP + "]";
    }
}

