/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPInitiate
extends PCEPMessage {
    protected LinkedList<PCEPIntiatedLSP> pcepIntiatedLSPList;
    private static final Logger log = LoggerFactory.getLogger("PCEPParser");

    public PCEPInitiate() {
        this.setMessageType(12);
        this.pcepIntiatedLSPList = new LinkedList();
    }

    public PCEPInitiate(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.pcepIntiatedLSPList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int index;
        int len = 4;
        for (index = 0; index < this.pcepIntiatedLSPList.size(); ++index) {
            this.pcepIntiatedLSPList.get(index).encode();
            len += this.pcepIntiatedLSPList.get(index).getLength();
        }
        if (this.pcepIntiatedLSPList.size() == 0) {
            log.warn("There should be at least one update request in a PCEP update Request message");
            throw new PCEPProtocolViolationException();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        for (index = 0; index < this.pcepIntiatedLSPList.size(); ++index) {
            System.arraycopy(this.pcepIntiatedLSPList.get(index).getBytes(), 0, this.messageBytes, offset, this.pcepIntiatedLSPList.get(index).getLength());
            offset += this.pcepIntiatedLSPList.get(index).getLength();
        }
    }

    public void decode() throws PCEPProtocolViolationException {
        int offset = 4;
        boolean atLeastOne = false;
        if (PCEPObject.getObjectClass(this.getBytes(), offset) != 33) {
            log.warn("There should be at least one RSP Object");
            throw new PCEPProtocolViolationException();
        }
        while (PCEPObject.getObjectClass(this.getBytes(), offset) == 33) {
            PCEPIntiatedLSP sr;
            try {
                log.info("this.getBytes(): " + this.getBytes());
                log.info("offset: " + offset);
                sr = new PCEPIntiatedLSP(this.getBytes(), offset);
            }
            catch (PCEPProtocolViolationException e) {
                log.warn("Malformed UpdateRequest Construct");
                throw new PCEPProtocolViolationException();
            }
            offset += sr.getLength();
            this.pcepIntiatedLSPList.add(sr);
            atLeastOne = true;
        }
        if (!atLeastOne) {
            log.warn("Malformed Report Message. There must be at least one state-report object. Exception will be throwed");
            throw new PCEPProtocolViolationException();
        }
    }

    public LinkedList<PCEPIntiatedLSP> getPcepIntiatedLSPList() {
        return this.pcepIntiatedLSPList;
    }

    public void setPcepIntiatedLSPList(LinkedList<PCEPIntiatedLSP> pcepIntiatedLSPList) {
        this.pcepIntiatedLSPList = pcepIntiatedLSPList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.pcepIntiatedLSPList.size() * 100);
        sb.append("INITIATE MESSAGE: ");
        for (int i = 0; i < this.pcepIntiatedLSPList.size(); ++i) {
            sb.append(this.pcepIntiatedLSPList.get(i).toString());
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pcepIntiatedLSPList == null ? 0 : this.pcepIntiatedLSPList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPInitiate other = (PCEPInitiate)obj;
        return !(this.pcepIntiatedLSPList == null ? other.pcepIntiatedLSPList != null : !this.pcepIntiatedLSPList.equals(other.pcepIntiatedLSPList));
    }
}

