/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.ErrorConstruct;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.OPEN;
import es.tid.pce.pcep.objects.PCEPErrorObject;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;

public class PCEPError
extends PCEPMessage {
    private LinkedList<PCEPErrorObject> errorObjList;
    private OPEN open;
    private LinkedList<ErrorConstruct> errorList;

    public PCEPError() {
        this.setMessageType(6);
        this.errorObjList = new LinkedList();
        this.errorList = new LinkedList();
    }

    public PCEPError(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.errorObjList = new LinkedList();
        this.errorList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        if (this.errorObjList.size() == 0 && this.errorList.size() == 0) {
            throw new PCEPProtocolViolationException();
        }
        int len = 4;
        for (i2 = 0; i2 < this.errorObjList.size(); ++i2) {
            this.errorObjList.get(i2).encode();
            len += this.errorObjList.get(i2).getLength();
        }
        if (this.open != null) {
            this.open.encode();
            len += this.open.getLength();
        }
        for (i2 = 0; i2 < this.errorList.size(); ++i2) {
            this.errorList.get(i2).encode();
            len += this.errorList.get(i2).getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[this.getLength()];
        this.encodeHeader();
        int offset = 4;
        for (i = 0; i < this.errorList.size(); ++i) {
            System.arraycopy(this.errorList.get(i).getBytes(), 0, this.messageBytes, offset, this.errorList.get(i).getLength());
            offset += this.errorList.get(i).getLength();
            len += this.errorList.get(i).getLength();
        }
        for (i = 0; i < this.errorObjList.size(); ++i) {
            System.arraycopy(this.errorObjList.get(i).getBytes(), 0, this.messageBytes, offset, this.errorObjList.get(i).getLength());
            offset += this.errorObjList.get(i).getLength();
        }
        if (this.errorObjList.size() > 0 && this.open != null) {
            System.arraycopy(this.open.getBytes(), 0, this.messageBytes, offset, this.open.getLength());
            offset += this.open.getLength();
        }
    }

    private void decode() throws PCEPProtocolViolationException {
        block18: {
            int oc;
            int offset;
            block17: {
                offset = 4;
                if (offset >= this.getLength()) {
                    this.log.warn("Empty Error message");
                    throw new PCEPProtocolViolationException();
                }
                oc = PCEPObject.getObjectClass(this.messageBytes, 4);
                if (oc != 2) break block17;
                while (oc == 2 || oc == 13) {
                    ErrorConstruct errc;
                    try {
                        errc = new ErrorConstruct(this.messageBytes, offset);
                    }
                    catch (PCEPProtocolViolationException e) {
                        this.log.warn("Problem Decoding Error Construct");
                        throw new PCEPProtocolViolationException();
                    }
                    this.errorList.add(errc);
                    if ((offset += errc.getLength()) >= this.getLength()) {
                        return;
                    }
                    oc = PCEPObject.getObjectClass(this.messageBytes, offset);
                }
                break block18;
            }
            if (oc != 13) break block18;
            while (oc == 13) {
                PCEPErrorObject perrobj;
                try {
                    perrobj = new PCEPErrorObject(this.messageBytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    this.log.warn("Problem Decoding Error Object");
                    e.printStackTrace();
                    throw new PCEPProtocolViolationException();
                }
                this.errorObjList.add(perrobj);
                if ((offset += perrobj.getLength()) >= this.getLength()) {
                    return;
                }
                oc = PCEPObject.getObjectClass(this.messageBytes, offset);
            }
            if (oc == 1) {
                try {
                    this.open = new OPEN(this.messageBytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    this.log.warn("Problem Decoding Error Object");
                    e.printStackTrace();
                    throw new PCEPProtocolViolationException();
                }
                if ((offset += this.open.getLength()) >= this.getLength()) {
                    return;
                }
                oc = PCEPObject.getObjectClass(this.messageBytes, offset);
            }
            while (oc == 2 || oc == 13) {
                ErrorConstruct errc;
                try {
                    errc = new ErrorConstruct(this.messageBytes, offset);
                }
                catch (PCEPProtocolViolationException e) {
                    this.log.warn("Problem Decoding Error Construct");
                    throw new PCEPProtocolViolationException();
                }
                this.errorList.add(errc);
                if ((offset += errc.getLength()) >= this.getLength()) {
                    return;
                }
                oc = PCEPObject.getObjectClass(this.messageBytes, offset);
            }
        }
    }

    public LinkedList<PCEPErrorObject> getErrorObjList() {
        return this.errorObjList;
    }

    public void setErrorObjList(LinkedList<PCEPErrorObject> errorObjList) {
        this.errorObjList = errorObjList;
    }

    public OPEN getOpen() {
        return this.open;
    }

    public void setOpen(OPEN open) {
        this.open = open;
    }

    public LinkedList<ErrorConstruct> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(LinkedList<ErrorConstruct> errorList) {
        this.errorList = errorList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.errorList == null ? 0 : this.errorList.hashCode());
        result = 31 * result + (this.errorObjList == null ? 0 : this.errorObjList.hashCode());
        result = 31 * result + (this.open == null ? 0 : this.open.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPError other = (PCEPError)obj;
        if (this.errorList == null ? other.errorList != null : !this.errorList.equals(other.errorList)) {
            return false;
        }
        if (this.errorObjList == null ? other.errorObjList != null : !this.errorObjList.equals(other.errorObjList)) {
            return false;
        }
        return !(this.open == null ? other.open != null : !this.open.equals(other.open));
    }
}

