/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.messages;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.objects.Close;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;

public class PCEPClose
extends PCEPMessage {
    private Close close;

    public PCEPClose() {
        this.setMessageType(7);
        this.close = new Close();
    }

    public PCEPClose(byte[] bytes) throws PCEPProtocolViolationException {
        super(bytes);
        this.decode();
    }

    public void setReason(int reason) {
        this.close.setReason(reason);
    }

    public int getReason() {
        return this.close.getReason();
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        this.close.encode();
        this.setMessageLength(4 + this.close.getLength());
        this.messageBytes = new byte[this.getLength()];
        this.encodeHeader();
        System.arraycopy(this.close.getBytes(), 0, this.messageBytes, 4, this.close.getLength());
    }

    private void decode() throws PCEPProtocolViolationException {
        int offset = 4;
        if (PCEPObject.getObjectClass(this.messageBytes, offset) == 15) {
            try {
                this.close = new Close(this.messageBytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                this.log.warn("Malformed PCEP Close object");
                throw new PCEPProtocolViolationException();
            }
        } else {
            throw new PCEPProtocolViolationException();
        }
    }

    public Close getClose() {
        return this.close;
    }

    public void setClose(Close close) {
        this.close = close;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.close == null ? 0 : this.close.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPClose other = (PCEPClose)obj;
        return !(this.close == null ? other.close != null : !this.close.equals(other.close));
    }
}

