/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.objects.Association;
import es.tid.pce.pcep.objects.AssociationIPv4;
import es.tid.pce.pcep.objects.AssociationIPv6;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.SRP;
import java.util.LinkedList;

public class UpdateRequest
extends PCEPConstruct {
    private LSP lsp;
    private SRP srp;
    private Path path;
    private LinkedList<Association> associationList = new LinkedList();

    public UpdateRequest() {
    }

    public UpdateRequest(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int length = 0;
        this.srp.encode();
        length += this.srp.getLength();
        if (this.lsp != null) {
            this.lsp.encode();
            length += this.lsp.getLength();
        }
        if (this.associationList != null) {
            for (int i = 0; i < this.associationList.size(); ++i) {
                this.associationList.get(i).encode();
                length += this.associationList.get(i).getLength();
            }
        }
        this.path.encode();
        this.setLength(length += this.path.getLength());
        this.bytes = new byte[length];
        int offset = 0;
        System.arraycopy(this.srp.getBytes(), 0, this.getBytes(), offset, this.srp.getLength());
        System.arraycopy(this.lsp.getBytes(), 0, this.getBytes(), offset += this.srp.getLength(), this.lsp.getLength());
        offset += this.lsp.getLength();
        for (int i = 0; i < this.associationList.size(); ++i) {
            System.arraycopy(this.associationList.get(i).getBytes(), 0, this.bytes, offset, this.associationList.get(i).getLength());
            offset += this.associationList.get(i).getLength();
        }
        System.arraycopy(this.path.getBytes(), 0, this.bytes, offset, this.path.getLength());
        offset += this.path.getLength();
    }

    protected void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int max_offset = bytes.length;
        if (offset >= max_offset) {
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 33) {
            try {
                this.srp = new SRP(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed SRP Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.srp.getLength();
        } else {
            log.warn("Malformed Update Request Construct. There must be at least one SRP object. Exception will be throwed");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset += this.srp.getLength());
        if (oc == 32) {
            try {
                this.lsp = new LSP(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed LSP Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.lsp.getLength();
        } else {
            log.warn("Malformed Update Request Construct. There must be at least one LSP object. Exception will be throwed");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset += this.lsp.getLength());
        int ot = PCEPObject.getObjectType(bytes, offset);
        log.debug("Checking ASSOCIATION");
        while (oc == 40) {
            Association aso = null;
            try {
                if (ot == 1) {
                    aso = new AssociationIPv4(bytes, offset);
                } else if (ot == 2) {
                    aso = new AssociationIPv6(bytes, offset);
                }
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ASSOCIATION Object found");
                throw new PCEPProtocolViolationException();
            }
            this.associationList.add(aso);
            len += aso.getLength();
            if ((offset += aso.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
        }
        if (PCEPObject.getObjectClass(bytes, offset) == 7) {
            this.path = new Path(bytes, offset);
            len += this.path.getLength();
            if ((offset += this.path.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        this.setLength(len);
    }

    public LSP getLsp() {
        return this.lsp;
    }

    public void setLsp(LSP lsp) {
        this.lsp = lsp;
    }

    public SRP getSrp() {
        return this.srp;
    }

    public void setSrp(SRP srp) {
        this.srp = srp;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public LinkedList<Association> getAssociationList() {
        return this.associationList;
    }

    public void setAssociationList(LinkedList<Association> associationList) {
        this.associationList = associationList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.associationList == null ? 0 : this.associationList.hashCode());
        result = 31 * result + (this.lsp == null ? 0 : this.lsp.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.srp == null ? 0 : this.srp.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateRequest other = (UpdateRequest)obj;
        if (this.associationList == null ? other.associationList != null : !this.associationList.equals(other.associationList)) {
            return false;
        }
        if (this.lsp == null ? other.lsp != null : !this.lsp.equals(other.lsp)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.srp == null ? other.srp != null : !this.srp.equals(other.srp));
    }

    public String toString() {
        return "UpdateRequest [lsp=" + this.lsp + ", srp=" + this.srp + ", path=" + this.path + ", associationList=" + this.associationList + "]";
    }
}

