/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.UnnumberedEndpointTLV;

public class UnnumIfEndPoint
extends EndPoint {
    private UnnumberedEndpointTLV unnumberedEndpoint;

    public UnnumIfEndPoint() {
    }

    public UnnumIfEndPoint(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() {
        int length = 0;
        if (this.unnumberedEndpoint != null) {
            this.unnumberedEndpoint.encode();
            length += this.unnumberedEndpoint.getTotalTLVLength();
        }
        this.setLength(length);
        this.bytes = new byte[this.getLength()];
        int offset = 0;
        if (this.unnumberedEndpoint != null) {
            System.arraycopy(this.unnumberedEndpoint.getTlv_bytes(), 0, this.bytes, offset, this.unnumberedEndpoint.getTotalTLVLength());
            offset += this.unnumberedEndpoint.getTotalTLVLength();
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int tlvtype = PCEPTLV.getType(bytes, offset);
        int tlvlength = PCEPTLV.getTotalTLVLength(bytes, offset);
        this.setLength(tlvlength);
        if (tlvtype == 41) {
            this.unnumberedEndpoint = new UnnumberedEndpointTLV(bytes, offset);
        }
    }

    public UnnumberedEndpointTLV getUnnumberedEndpoint() {
        return this.unnumberedEndpoint;
    }

    public void setUnnumberedEndpoint(UnnumberedEndpointTLV unnumberedEndpoint) {
        this.unnumberedEndpoint = unnumberedEndpoint;
    }
}

