/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.objects.Association;
import es.tid.pce.pcep.objects.AssociationIPv4;
import es.tid.pce.pcep.objects.AssociationIPv6;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.SRP;
import java.util.LinkedList;
import java.util.Objects;

public class StateReport
extends PCEPConstruct {
    SRP srp;
    LSP lsp;
    Path path;
    private LinkedList<Association> associationList = new LinkedList();

    public StateReport() {
    }

    public StateReport(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int length = 0;
        if (this.srp != null) {
            this.srp.encode();
            length += this.srp.getLength();
        }
        if (this.lsp != null) {
            this.lsp.encode();
            length += this.lsp.getLength();
        } else {
            log.warn("LSP Object compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.associationList != null) {
            for (int i = 0; i < this.associationList.size(); ++i) {
                this.associationList.get(i).encode();
                length += this.associationList.get(i).getLength();
            }
        }
        if (this.path == null) {
            log.warn("PATH Construct compulsory");
            throw new PCEPProtocolViolationException();
        }
        this.path.encode();
        this.setLength(length += this.path.getLength());
        this.bytes = new byte[length];
        int offset = 0;
        if (this.srp != null) {
            System.arraycopy(this.srp.getBytes(), 0, this.getBytes(), offset, this.srp.getLength());
            offset += this.srp.getLength();
        }
        if (this.lsp != null) {
            System.arraycopy(this.lsp.getBytes(), 0, this.getBytes(), offset, this.lsp.getLength());
            offset += this.lsp.getLength();
        }
        for (int i = 0; i < this.associationList.size(); ++i) {
            System.arraycopy(this.associationList.get(i).getBytes(), 0, this.bytes, offset, this.associationList.get(i).getLength());
            offset += this.associationList.get(i).getLength();
        }
        if (this.path != null) {
            System.arraycopy(this.path.getBytes(), 0, this.bytes, offset, this.path.getLength());
            offset += this.path.getLength();
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int oc;
        int len;
        block20: {
            len = 0;
            int max_offset = bytes.length;
            if (offset >= max_offset) {
                throw new PCEPProtocolViolationException();
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
            log.debug("Voy  ver el SRP oc " + oc + " offset " + offset);
            if (oc == 33) {
                try {
                    this.srp = new SRP(bytes, offset);
                    offset += this.srp.getLength();
                    len += this.srp.getLength();
                }
                catch (MalformedPCEPObjectException e) {
                    e.printStackTrace();
                }
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
            log.debug("Voy a ver el LSP, oc " + oc + " offset " + offset);
            if (oc == 32) {
                try {
                    this.lsp = new LSP(bytes, offset);
                    len += this.lsp.getLength();
                    if ((offset += this.lsp.getLength()) >= bytes.length) {
                        this.setLength(len);
                        return;
                    }
                    break block20;
                }
                catch (MalformedPCEPObjectException e) {
                    log.warn("Malformed LSP Object found");
                    throw new PCEPProtocolViolationException();
                }
            }
            log.warn("Malformed Report Message. There must be at least one LSP object. Exception will be throwed");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        log.debug("Voy a ver el ASSOCIATION, oc " + oc + " offset " + offset + "OT: " + ot);
        while (oc == 40) {
            Association aso = null;
            try {
                if (ot == 1) {
                    aso = new AssociationIPv4(bytes, offset);
                } else if (ot == 2) {
                    aso = new AssociationIPv6(bytes, offset);
                }
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ASSOCIATION Object found");
                throw new PCEPProtocolViolationException();
            }
            this.associationList.add(aso);
            len += aso.getLength();
            if ((offset += aso.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
        }
        log.debug("Voy a ver el ERO, oc " + oc + " offset " + offset + "OT: " + ot);
        if (PCEPObject.getObjectClass(bytes, offset) == 7) {
            this.path = new Path(bytes, offset);
            len += this.path.getLength();
            if ((offset += this.path.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        } else {
            log.warn("Malformed Report Message. There must be at least one ERO or SRERO message!");
        }
        if (PCEPObject.getObjectClass(bytes, offset) == 34) {
            offset += PCEPObject.getObjectLength(bytes, offset);
            len += PCEPObject.getObjectLength(bytes, offset);
            if (offset >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        this.setLength(len);
    }

    public SRP getSrp() {
        return this.srp;
    }

    public void setSrp(SRP srp) {
        this.srp = srp;
    }

    public LSP getLsp() {
        return this.lsp;
    }

    public void setLsp(LSP lsp) {
        this.lsp = lsp;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public LinkedList<Association> getAssociationList() {
        return this.associationList;
    }

    public void setAssociationList(LinkedList<Association> associationList) {
        this.associationList = associationList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.associationList, this.lsp, this.path, this.srp);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateReport other = (StateReport)obj;
        return Objects.equals(this.associationList, other.associationList) && Objects.equals(this.lsp, other.lsp) && Objects.equals(this.path, other.path) && Objects.equals(this.srp, other.srp);
    }

    public String toString() {
        return "StateReport [srp=" + this.srp + ", lsp=" + this.lsp + ", path=" + this.path + ", associationList=" + this.associationList + "]";
    }
}

