/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.MetricPCE;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.IncludeRouteObject;
import es.tid.pce.pcep.objects.LSPA;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.PccReqId;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.ReservationConf;
import java.util.LinkedList;

public class Response
extends PCEPConstruct {
    private RequestParameters requestParameters;
    private Monitoring monitoring;
    private PccReqId pccIdreq;
    private NoPath noPath;
    private LSPA lSPA;
    private Bandwidth bandwidth;
    private LinkedList<Metric> metricList = new LinkedList();
    private IncludeRouteObject iRO;
    private ReservationConf resConf;
    private LinkedList<Path> pathList = new LinkedList();
    private LinkedList<MetricPCE> metricPCEList = new LinkedList();

    public Response() {
    }

    public Response(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    public RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(RequestParameters requestParameters) {
        this.requestParameters = requestParameters;
    }

    public NoPath getNoPath() {
        return this.noPath;
    }

    public void setNoPath(NoPath noPath) {
        this.noPath = noPath;
    }

    public LSPA getLSPA() {
        return this.lSPA;
    }

    public void setLSPA(LSPA lSPA) {
        this.lSPA = lSPA;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    public IncludeRouteObject getIRO() {
        return this.iRO;
    }

    public void setIRO(IncludeRouteObject iRO) {
        this.iRO = iRO;
    }

    public LinkedList<Path> getPathList() {
        return this.pathList;
    }

    public void addPath(Path path) {
        this.pathList.add(path);
    }

    public Path getPath(int index) {
        return this.pathList.get(index);
    }

    public void setPathList(LinkedList<Path> pathList) {
        this.pathList = pathList;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public PccReqId getPccIdreq() {
        return this.pccIdreq;
    }

    public void setPccIdreq(PccReqId pccIdreq) {
        this.pccIdreq = pccIdreq;
    }

    public LinkedList<MetricPCE> getMetricPCEList() {
        return this.metricPCEList;
    }

    public void setMetricPCEList(LinkedList<MetricPCE> metricPCEList) {
        this.metricPCEList = metricPCEList;
    }

    public ReservationConf getResConf() {
        return this.resConf;
    }

    public void setResConf(ReservationConf resConf) {
        this.resConf = resConf;
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        int len = 0;
        if (this.requestParameters != null) {
            this.requestParameters.encode();
            len += this.requestParameters.getLength();
        } else {
            log.warn("requestParameters is compulsory in response");
            throw new PCEPProtocolViolationException();
        }
        if (this.monitoring != null) {
            this.monitoring.encode();
            len += this.monitoring.getLength();
        }
        if (this.pccIdreq != null) {
            this.pccIdreq.encode();
            len += this.pccIdreq.getLength();
        }
        if (this.noPath != null) {
            this.noPath.encode();
            len += this.noPath.getLength();
        }
        if (this.lSPA != null) {
            this.lSPA.encode();
            len += this.lSPA.getLength();
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        if (this.metricList != null) {
            for (i2 = 0; i2 < this.metricList.size(); ++i2) {
                this.metricList.get(i2).encode();
                len += this.metricList.get(i2).getLength();
            }
        }
        if (this.iRO != null) {
            this.iRO.encode();
            len += this.iRO.getLength();
        }
        if (this.resConf != null) {
            this.resConf.encode();
            len += this.resConf.getLength();
        }
        if (this.pathList != null) {
            for (i2 = 0; i2 < this.pathList.size(); ++i2) {
                this.pathList.get(i2).encode();
                len += this.pathList.get(i2).getLength();
            }
        }
        if (this.metricPCEList != null) {
            for (i2 = 0; i2 < this.metricPCEList.size(); ++i2) {
                this.metricPCEList.get(i2).encode();
                len += this.metricPCEList.get(i2).getLength();
            }
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.requestParameters.getBytes(), 0, this.bytes, offset, this.requestParameters.getLength());
        offset += this.requestParameters.getLength();
        if (this.monitoring != null) {
            System.arraycopy(this.monitoring.getBytes(), 0, this.bytes, offset, this.monitoring.getLength());
            offset += this.monitoring.getLength();
        }
        if (this.pccIdreq != null) {
            System.arraycopy(this.pccIdreq.getBytes(), 0, this.bytes, offset, this.pccIdreq.getLength());
            offset += this.pccIdreq.getLength();
        }
        if (this.noPath != null) {
            System.arraycopy(this.noPath.getBytes(), 0, this.bytes, offset, this.noPath.getLength());
            offset += this.noPath.getLength();
        }
        if (this.lSPA != null) {
            System.arraycopy(this.lSPA.getBytes(), 0, this.bytes, offset, this.lSPA.getLength());
            offset += this.lSPA.getLength();
        }
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
        for (i = 0; i < this.metricList.size(); ++i) {
            System.arraycopy(this.metricList.get(i).getBytes(), 0, this.bytes, offset, this.metricList.get(i).getLength());
            offset += this.metricList.get(i).getLength();
        }
        if (this.iRO != null) {
            System.arraycopy(this.iRO.getBytes(), 0, this.bytes, offset, this.iRO.getLength());
            offset += this.iRO.getLength();
        }
        if (this.resConf != null) {
            System.arraycopy(this.resConf.getBytes(), 0, this.bytes, offset, this.resConf.getLength());
            offset += this.resConf.getLength();
        }
        for (i = 0; i < this.pathList.size(); ++i) {
            System.arraycopy(this.pathList.get(i).getBytes(), 0, this.bytes, offset, this.pathList.get(i).getLength());
            offset += this.pathList.get(i).getLength();
        }
        for (i = 0; i < this.metricPCEList.size(); ++i) {
            System.arraycopy(this.metricPCEList.get(i).getBytes(), 0, this.bytes, offset, this.metricPCEList.get(i).getLength());
            offset += this.metricPCEList.get(i).getLength();
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        if (oc == 2) {
            try {
                this.requestParameters = new RequestParameters(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed RP Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.requestParameters.getLength();
            if ((offset += this.requestParameters.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        } else {
            log.warn("Request must start with RP object");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 19) {
            try {
                this.monitoring = new Monitoring(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed Monitoring Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.monitoring.getLength();
            if ((offset += this.monitoring.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 20) {
            try {
                this.pccIdreq = new PccReqId(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed PCC ID REQ Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.pccIdreq.getLength();
            if ((offset += this.pccIdreq.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 3) {
            try {
                this.noPath = new NoPath(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed NOPATH Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.noPath.getLength();
            if ((offset += this.noPath.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 9) {
            try {
                this.lSPA = new LSPA(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed LSPA Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.lSPA.getLength();
            if ((offset += this.lSPA.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                } else {
                    log.warn("Malformed BANDWIDTH Object found");
                    throw new PCEPProtocolViolationException();
                }
                len += this.bandwidth.getLength();
                if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                    this.setLength(len);
                    return;
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            Metric metric;
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            if ((offset += metric.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 10) {
            try {
                this.iRO = new IncludeRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed IRO Object found");
                throw new PCEPProtocolViolationException();
            }
            if ((offset += this.iRO.getLength()) + (len += this.iRO.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 161) {
            try {
                this.resConf = new ReservationConf(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed RESERVATION CONF  Object found");
                throw new PCEPProtocolViolationException();
            }
            if ((offset += this.resConf.getLength()) + (len += this.resConf.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 7) {
            Path path = new Path(bytes, offset);
            this.pathList.add(path);
            len += path.getLength();
            if ((offset += path.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 25) {
            MetricPCE metricPCE = new MetricPCE(bytes, offset);
            this.metricPCEList.add(metricPCE);
            if ((offset += metricPCE.getLength()) + (len += metricPCE.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        this.setLength(len);
    }

    public String toString() {
        int i;
        String ret = "";
        if (this.requestParameters != null) {
            ret = ret + this.requestParameters.toString();
        }
        if (this.noPath != null) {
            ret = ret + "<NOPATH>";
        }
        if (this.lSPA != null) {
            ret = ret + "<LSPA>";
        }
        if (this.bandwidth != null) {
            ret = ret + "<BW>";
        }
        if (this.metricList != null) {
            for (i = 0; i < this.metricList.size(); ++i) {
                ret = ret + this.metricList.get(i).toString();
            }
        }
        if (this.iRO != null) {
            ret = ret + "<IRO>";
        }
        if (this.pathList != null) {
            for (i = 0; i < this.pathList.size(); ++i) {
                ret = ret + this.pathList.get(i).toString();
            }
        }
        if (this.metricPCEList != null) {
            for (i = 0; i < this.metricPCEList.size(); ++i) {
                ret = ret + this.metricPCEList.get(i).toString();
            }
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandwidth == null ? 0 : this.bandwidth.hashCode());
        result = 31 * result + (this.iRO == null ? 0 : this.iRO.hashCode());
        result = 31 * result + (this.lSPA == null ? 0 : this.lSPA.hashCode());
        result = 31 * result + (this.metricList == null ? 0 : this.metricList.hashCode());
        result = 31 * result + (this.metricPCEList == null ? 0 : this.metricPCEList.hashCode());
        result = 31 * result + (this.monitoring == null ? 0 : this.monitoring.hashCode());
        result = 31 * result + (this.noPath == null ? 0 : this.noPath.hashCode());
        result = 31 * result + (this.pathList == null ? 0 : this.pathList.hashCode());
        result = 31 * result + (this.pccIdreq == null ? 0 : this.pccIdreq.hashCode());
        result = 31 * result + (this.requestParameters == null ? 0 : this.requestParameters.hashCode());
        result = 31 * result + (this.resConf == null ? 0 : this.resConf.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Response other = (Response)obj;
        if (this.bandwidth == null ? other.bandwidth != null : !this.bandwidth.equals(other.bandwidth)) {
            return false;
        }
        if (this.iRO == null ? other.iRO != null : !this.iRO.equals(other.iRO)) {
            return false;
        }
        if (this.lSPA == null ? other.lSPA != null : !this.lSPA.equals(other.lSPA)) {
            return false;
        }
        if (this.metricList == null ? other.metricList != null : !this.metricList.equals(other.metricList)) {
            return false;
        }
        if (this.metricPCEList == null ? other.metricPCEList != null : !this.metricPCEList.equals(other.metricPCEList)) {
            return false;
        }
        if (this.monitoring == null ? other.monitoring != null : !this.monitoring.equals(other.monitoring)) {
            return false;
        }
        if (this.noPath == null ? other.noPath != null : !this.noPath.equals(other.noPath)) {
            return false;
        }
        if (this.pathList == null ? other.pathList != null : !this.pathList.equals(other.pathList)) {
            return false;
        }
        if (this.pccIdreq == null ? other.pccIdreq != null : !this.pccIdreq.equals(other.pccIdreq)) {
            return false;
        }
        if (this.requestParameters == null ? other.requestParameters != null : !this.requestParameters.equals(other.requestParameters)) {
            return false;
        }
        return !(this.resConf == null ? other.resConf != null : !this.resConf.equals(other.resConf));
    }
}

