/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.ReportedRouteObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RROBandwidth
extends PCEPConstruct {
    private ReportedRouteObject rRO;
    private Bandwidth bandwidth;
    private static final Logger log = LoggerFactory.getLogger("PCEPParser");

    public RROBandwidth() {
    }

    public RROBandwidth(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 0;
        if (this.rRO != null) {
            this.rRO.encode();
            len += this.rRO.getLength();
        } else {
            log.warn("RRO/BANDWIDTH Rule must start with RRO object");
            throw new PCEPProtocolViolationException();
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.rRO.getBytes(), 0, this.bytes, offset, this.rRO.getLength());
        offset += this.rRO.getLength();
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
    }

    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        if (oc == 8) {
            try {
                this.rRO = new ReportedRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ReportedRouteObject Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.rRO.getLength();
            len += this.rRO.getLength();
        } else {
            throw new PCEPProtocolViolationException();
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                } else {
                    log.warn("Malformed BANDWIDTH Object found");
                    throw new PCEPProtocolViolationException();
                }
                len += this.bandwidth.getLength();
                if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                    this.setLength(len);
                    return;
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        this.setLength(len);
    }

    public ReportedRouteObject getRRO() {
        return this.rRO;
    }

    public void setRRO(ReportedRouteObject rRO) {
        this.rRO = rRO;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandwidth == null ? 0 : this.bandwidth.hashCode());
        result = 31 * result + (this.rRO == null ? 0 : this.rRO.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RROBandwidth other = (RROBandwidth)obj;
        if (this.bandwidth == null ? other.bandwidth != null : !this.bandwidth.equals(other.bandwidth)) {
            return false;
        }
        return !(this.rRO == null ? other.rRO != null : !this.rRO.equals(other.rRO));
    }
}

