/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.Association;
import es.tid.pce.pcep.objects.AssociationIPv4;
import es.tid.pce.pcep.objects.AssociationIPv6;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.EndPointDataPathID;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsIPv6;
import es.tid.pce.pcep.objects.EndPointsUnnumberedIntf;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.P2MPEndPointsIPv4;
import es.tid.pce.pcep.objects.P2PGeneralizedEndPoints;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.SRP;
import java.util.LinkedList;
import java.util.Objects;

public class PCEPIntiatedLSP
extends PCEPConstruct {
    private SRP srp;
    private LSP lsp;
    private ExplicitRouteObject ero;
    private EndPoints endPoint;
    private LinkedList<Association> associationList;
    private LinkedList<Metric> metricList = new LinkedList();
    private Bandwidth bandwidth;

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public PCEPIntiatedLSP() {
        this.associationList = new LinkedList();
    }

    public PCEPIntiatedLSP(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.associationList = new LinkedList();
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        int len = 0;
        this.srp.encode();
        this.lsp.encode();
        len += this.srp.getLength();
        len += this.lsp.getLength();
        if (this.endPoint != null) {
            this.endPoint.encode();
            len += this.endPoint.getLength();
        }
        if (this.ero != null) {
            this.ero.encode();
            len += this.ero.getLength();
        } else {
            log.warn("NO ERO ...");
        }
        if (this.associationList != null) {
            for (i2 = 0; i2 < this.associationList.size(); ++i2) {
                this.associationList.get(i2).encode();
                len += this.associationList.get(i2).getLength();
            }
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        if (this.metricList != null) {
            for (i2 = 0; i2 < this.metricList.size(); ++i2) {
                this.metricList.get(i2).encode();
                len += this.metricList.get(i2).getLength();
            }
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.srp.getBytes(), 0, this.getBytes(), offset, this.srp.getLength());
        System.arraycopy(this.lsp.getBytes(), 0, this.getBytes(), offset += this.srp.getLength(), this.lsp.getLength());
        offset += this.lsp.getLength();
        if (this.endPoint != null) {
            System.arraycopy(this.endPoint.getBytes(), 0, this.getBytes(), offset, this.endPoint.getLength());
            offset += this.endPoint.getLength();
        }
        System.out.println("offset " + offset);
        if (this.ero != null) {
            System.arraycopy(this.ero.getBytes(), 0, this.getBytes(), offset, this.ero.getLength());
            offset += this.ero.getLength();
        }
        for (i = 0; i < this.associationList.size(); ++i) {
            System.arraycopy(this.associationList.get(i).getBytes(), 0, this.bytes, offset, this.associationList.get(i).getLength());
            offset += this.associationList.get(i).getLength();
        }
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
        for (i = 0; i < this.metricList.size(); ++i) {
            System.arraycopy(this.metricList.get(i).getBytes(), 0, this.bytes, offset, this.metricList.get(i).getLength());
            offset += this.metricList.get(i).getLength();
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int max_offset = bytes.length;
        if (offset >= max_offset) {
            log.warn("Empty Request construct!!!");
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        if (oc != 33) {
            log.info("There should be at least one SRP Object");
            throw new PCEPProtocolViolationException();
        }
        try {
            this.srp = new SRP(bytes, offset);
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed LSP Object found");
            throw new PCEPProtocolViolationException();
        }
        len += this.srp.getLength();
        if ((offset += this.srp.getLength()) >= max_offset) {
            this.setLength(len);
            log.warn("Just one SRP object found, no more");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        if (oc != 32) {
            log.warn("There should be at least one LSP Object");
            throw new PCEPProtocolViolationException();
        }
        try {
            this.lsp = new LSP(bytes, offset);
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed LSP Object found");
            throw new PCEPProtocolViolationException();
        }
        len += this.lsp.getLength();
        if ((offset += this.lsp.getLength()) >= max_offset) {
            this.setLength(len);
            log.warn("Just one SRP and one LSP object found, no more");
            log.warn("TEMPORAL FIX");
            return;
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        if (oc != 4) {
            log.warn("There should be at least one EndPoint Object. Should throw Ex");
        } else {
            block60: {
                try {
                    if (ot == 3) {
                        try {
                            this.endPoint = new P2MPEndPointsIPv4(bytes, offset);
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed P2MP ENDPOINTS IPV4 Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    if (ot == 1) {
                        try {
                            this.endPoint = new EndPointsIPv4(bytes, offset);
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed ENDPOINTS IPV4 Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    if (ot == 10) {
                        try {
                            this.endPoint = new EndPointsUnnumberedIntf(bytes, offset);
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed ENDPOINTS Unnumbered Interface Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    if (ot == 2) {
                        try {
                            this.endPoint = new EndPointsIPv6(bytes, offset);
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed ENDPOINTSIPV6 Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    if (ot == 5) {
                        try {
                            int endPointType = GeneralizedEndPoints.getGeneralizedEndPointsType(bytes, offset);
                            if (endPointType == 1) {
                                this.endPoint = new P2PGeneralizedEndPoints(bytes, offset);
                            }
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed GENERALIZED END POINTS Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    if (ot == 14) {
                        try {
                            this.endPoint = new EndPointDataPathID(bytes, offset);
                            break block60;
                        }
                        catch (MalformedPCEPObjectException e) {
                            log.warn("Malformed GENERALIZED END POINTS Object found");
                            throw new PCEPProtocolViolationException();
                        }
                    }
                    log.warn("BANDWIDTH TYPE NOT SUPPORTED");
                    throw new PCEPProtocolViolationException();
                }
                catch (Exception e) {
                    log.warn("Malformed EndPoint Object found");
                }
            }
            if (this.endPoint != null) {
                len += this.endPoint.getLength();
                if ((offset += this.endPoint.getLength()) >= max_offset) {
                    this.setLength(len);
                    log.warn("Just one SRP, one LSP and one END-POINTS, object found, no more");
                }
            }
        }
        if (PCEPObject.getObjectClass(bytes, offset) == 7) {
            try {
                this.ero = new ExplicitRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ERO Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.ero.getLength();
            len += this.ero.getLength();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        ot = PCEPObject.getObjectType(bytes, offset);
        while (oc == 40) {
            Association aso = null;
            try {
                if (ot == 1) {
                    aso = new AssociationIPv4(bytes, offset);
                } else if (ot == 2) {
                    aso = new AssociationIPv6(bytes, offset);
                }
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.associationList.add(aso);
            len += aso.getLength();
            if ((offset += aso.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                } else if (ot == 4) {
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                } else {
                    log.warn("Malformed BANDWIDTH Object found");
                    throw new PCEPProtocolViolationException();
                }
                len += this.bandwidth.getLength();
                if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                    this.setLength(len);
                    return;
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 6) {
            Metric metric;
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            if ((offset += metric.getLength()) >= bytes.length) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        this.setLength(len);
    }

    public SRP getRsp() {
        return this.srp;
    }

    public void setRsp(SRP rsp) {
        this.srp = rsp;
    }

    public SRP getSrp() {
        return this.srp;
    }

    public void setSrp(SRP srp) {
        this.srp = srp;
    }

    public LSP getLsp() {
        return this.lsp;
    }

    public void setLsp(LSP lsp) {
        this.lsp = lsp;
    }

    public ExplicitRouteObject getEro() {
        return this.ero;
    }

    public void setEro(ExplicitRouteObject ero) {
        this.ero = ero;
    }

    public EndPoints getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(EndPoints endPoint) {
        this.endPoint = endPoint;
    }

    public LinkedList<Association> getAssociationList() {
        return this.associationList;
    }

    public void setAssociationList(LinkedList<Association> associationList) {
        this.associationList = associationList;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.associationList, this.bandwidth, this.endPoint, this.ero, this.lsp, this.metricList, this.srp);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPIntiatedLSP other = (PCEPIntiatedLSP)obj;
        return Objects.equals(this.associationList, other.associationList) && Objects.equals(this.bandwidth, other.bandwidth) && Objects.equals(this.endPoint, other.endPoint) && Objects.equals(this.ero, other.ero) && Objects.equals(this.lsp, other.lsp) && Objects.equals(this.metricList, other.metricList) && Objects.equals(this.srp, other.srp);
    }

    public String toString() {
        return "PCEPIntiatedLSP [srp=" + this.srp + ", lsp=" + this.lsp + ", ero=" + this.ero + ", endPoint=" + this.endPoint + ", associationList=" + this.associationList + ", metricList=" + this.metricList + ", bandwidth=" + this.bandwidth + "]";
    }
}

