/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.PceId;
import es.tid.pce.pcep.objects.PceIdIPv4;
import es.tid.pce.pcep.objects.ProcTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricPCE
extends PCEPConstruct {
    private PceId pceId;
    private ProcTime procTime;
    private static final Logger log = LoggerFactory.getLogger("PCEPParser");

    public MetricPCE() {
    }

    public MetricPCE(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 0;
        if (this.pceId != null) {
            this.pceId.encode();
            len += this.pceId.getLength();
        } else {
            log.warn("Metric PCE Rule must start with PCE ID object");
            throw new PCEPProtocolViolationException();
        }
        if (this.procTime != null) {
            this.procTime.encode();
            len += this.procTime.getLength();
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.pceId.getBytes(), 0, this.bytes, offset, this.pceId.getLength());
        offset += this.pceId.getLength();
        if (this.procTime != null) {
            System.arraycopy(this.procTime.getBytes(), 0, this.bytes, offset, this.procTime.getLength());
            offset += this.procTime.getLength();
        }
    }

    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        if (oc == 25) {
            if (ot == 1) {
                try {
                    this.pceId = new PceIdIPv4(bytes, offset);
                }
                catch (MalformedPCEPObjectException e) {
                    log.warn("Malformed pceId Object found");
                    throw new PCEPProtocolViolationException();
                }
                offset += this.pceId.getLength();
                len += this.pceId.getLength();
            }
        } else {
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 26) {
            try {
                this.procTime = new ProcTime(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ProcTime Object found");
                throw new PCEPProtocolViolationException();
            }
            offset += this.procTime.getLength();
            len += this.procTime.getLength();
        }
        this.setLength(len);
    }

    public PceId getPceId() {
        return this.pceId;
    }

    public void setPceId(PceId pceId) {
        this.pceId = pceId;
    }

    public ProcTime getProcTime() {
        return this.procTime;
    }

    public void setProcTime(ProcTime procTime) {
        this.procTime = procTime;
    }

    public String toString() {
        String ret = "";
        if (this.pceId != null) {
            ret = ret + this.pceId.toString();
        }
        if (this.procTime != null) {
            ret = ret + this.procTime.toString();
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pceId == null ? 0 : this.pceId.hashCode());
        result = 31 * result + (this.procTime == null ? 0 : this.procTime.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricPCE other = (MetricPCE)obj;
        if (this.pceId == null ? other.pceId != null : !this.pceId.equals(other.pceId)) {
            return false;
        }
        return !(this.procTime == null ? other.procTime != null : !this.procTime.equals(other.procTime));
    }
}

