/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.BandwidthExistingLSPGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsIPv6;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.LSPA;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.P2PGeneralizedEndPoints;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;

public class LSPInstantationRequest
extends PCEPConstruct {
    private EndPoints endPoints;
    private LSPA lSPA;
    private ExplicitRouteObject eRO;
    private Bandwidth bandwidth;
    private LinkedList<Metric> metricList = new LinkedList();

    public LSPInstantationRequest() {
    }

    public LSPInstantationRequest(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int len = 0;
        if (this.endPoints != null) {
            this.endPoints.encode();
            len += this.endPoints.getLength();
        } else {
            log.warn("EndPoints not found! They are compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.lSPA != null) {
            this.lSPA.encode();
            len += this.lSPA.getLength();
        } else {
            log.warn("lSPA not found! It is compulsory");
            throw new PCEPProtocolViolationException();
        }
        if (this.eRO != null) {
            this.eRO.encode();
            len += this.eRO.getLength();
        }
        if (this.bandwidth != null) {
            this.bandwidth.encode();
            len += this.bandwidth.getLength();
        }
        if (this.metricList != null) {
            for (int i = 0; i < this.metricList.size(); ++i) {
                this.metricList.get(i).encode();
                len += this.metricList.get(i).getLength();
            }
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        System.arraycopy(this.endPoints.getBytes(), 0, this.bytes, offset, this.endPoints.getLength());
        System.arraycopy(this.lSPA.getBytes(), 0, this.bytes, offset += this.endPoints.getLength(), this.lSPA.getLength());
        offset += this.lSPA.getLength();
        if (this.eRO != null) {
            System.arraycopy(this.eRO.getBytes(), 0, this.getBytes(), offset, this.eRO.getLength());
            offset += this.eRO.getLength();
        }
        if (this.bandwidth != null) {
            System.arraycopy(this.bandwidth.getBytes(), 0, this.bytes, offset, this.bandwidth.getLength());
            offset += this.bandwidth.getLength();
        }
        if (this.metricList != null) {
            for (int i = 0; i < this.metricList.size(); ++i) {
                System.arraycopy(this.metricList.get(i).getBytes(), 0, this.bytes, offset, this.metricList.get(i).getLength());
                offset += this.metricList.get(i).getLength();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int max_offset = bytes.length;
        if (offset >= max_offset) {
            log.warn("Empty Request construct!!!");
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(bytes, offset);
        int ot = PCEPObject.getObjectType(bytes, offset);
        if (oc != 4) {
            log.warn("LSPInstantationRequest must start with ENDPOINTS");
            throw new PCEPProtocolViolationException();
        }
        if (ot == 1) {
            try {
                this.endPoints = new EndPointsIPv4(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ENDPOINTS IPV4 Object found");
                throw new PCEPProtocolViolationException();
            }
        }
        if (ot == 2) {
            try {
                this.endPoints = new EndPointsIPv6(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ENDPOINTSIPV6 Object found");
                throw new PCEPProtocolViolationException();
            }
        }
        if (ot != 5) {
            log.warn("ENDPOINTS TYPE NOT SUPPORTED");
            throw new PCEPProtocolViolationException();
        }
        try {
            int endPointType = GeneralizedEndPoints.getGeneralizedEndPointsType(bytes, offset);
            if (endPointType == 1) {
                this.endPoints = new P2PGeneralizedEndPoints(bytes, offset);
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed GENERALIZED END POINTS Object found");
            throw new PCEPProtocolViolationException();
        }
        len += this.endPoints.getLength();
        if ((offset += this.endPoints.getLength()) >= max_offset) {
            this.setLength(len);
            return;
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        if (oc == 9) {
            try {
                this.lSPA = new LSPA(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed LSPA Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.lSPA.getLength();
            if ((offset += this.lSPA.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        } else {
            log.warn("LSPInstantationRequest follow with an LSPA after the ENDPOINTS");
        }
        if ((oc = PCEPObject.getObjectClass(bytes, offset)) == 7) {
            try {
                this.eRO = new ExplicitRouteObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed ERO Object found");
                throw new PCEPProtocolViolationException();
            }
            len += this.eRO.getLength();
            if ((offset += this.eRO.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
        }
        try {
            oc = PCEPObject.getObjectClass(bytes, offset);
            ot = PCEPObject.getObjectType(bytes, offset);
            if (oc == 5) {
                if (ot == 1) {
                    this.bandwidth = new BandwidthRequested(bytes, offset);
                } else if (ot == 2) {
                    this.bandwidth = new BandwidthExistingLSP(bytes, offset);
                } else if (ot == 3) {
                    this.bandwidth = new BandwidthRequestedGeneralizedBandwidth(bytes, offset);
                } else {
                    if (ot != 4) {
                        log.warn("Malformed BANDWIDTH Object found");
                        throw new PCEPProtocolViolationException();
                    }
                    this.bandwidth = new BandwidthExistingLSPGeneralizedBandwidth(bytes, offset);
                }
                len += this.bandwidth.getLength();
                if ((offset += this.bandwidth.getLength()) >= bytes.length) {
                    this.setLength(len);
                    return;
                }
            }
        }
        catch (MalformedPCEPObjectException e) {
            log.warn("Malformed BANDWIDTH Object found");
            throw new PCEPProtocolViolationException();
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (true) {
            Metric metric;
            if (oc != 6) {
                this.setLength(len);
                return;
            }
            try {
                metric = new Metric(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.metricList.add(metric);
            len += metric.getLength();
            if ((offset += metric.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
    }

    public EndPoints getEndPoints() {
        return this.endPoints;
    }

    public void setEndPoints(EndPoints endPoints) {
        this.endPoints = endPoints;
    }

    public LSPA getLSPA() {
        return this.lSPA;
    }

    public void setLSPA(LSPA lSPA) {
        this.lSPA = lSPA;
    }

    public ExplicitRouteObject getERO() {
        return this.eRO;
    }

    public void setERO(ExplicitRouteObject eRO) {
        this.eRO = eRO;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public LinkedList<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(LinkedList<Metric> metricList) {
        this.metricList = metricList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.endPoints != null) {
            sb.append(this.endPoints);
        }
        if (this.lSPA != null) {
            sb.append(this.lSPA);
        }
        if (this.eRO != null) {
            sb.append(this.eRO.toString());
        }
        if (this.bandwidth != null) {
            sb.append(this.bandwidth.toString());
        }
        if (this.metricList != null) {
            for (int i = 0; i < this.metricList.size(); ++i) {
                sb.append(this.metricList.get(i).toString());
            }
        }
        return sb.toString();
    }

    public LSPInstantationRequest duplicate() {
        LSPInstantationRequest req = new LSPInstantationRequest();
        req.setEndPoints(this.endPoints);
        req.setLSPA(this.lSPA);
        req.setERO(this.eRO);
        req.setBandwidth(this.bandwidth);
        req.setMetricList(this.metricList);
        return req;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandwidth == null ? 0 : this.bandwidth.hashCode());
        result = 31 * result + (this.eRO == null ? 0 : this.eRO.hashCode());
        result = 31 * result + (this.endPoints == null ? 0 : this.endPoints.hashCode());
        result = 31 * result + (this.lSPA == null ? 0 : this.lSPA.hashCode());
        result = 31 * result + (this.metricList == null ? 0 : this.metricList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LSPInstantationRequest other = (LSPInstantationRequest)obj;
        if (this.bandwidth == null ? other.bandwidth != null : !this.bandwidth.equals(other.bandwidth)) {
            return false;
        }
        if (this.eRO == null ? other.eRO != null : !this.eRO.equals(other.eRO)) {
            return false;
        }
        if (this.endPoints == null ? other.endPoints != null : !this.endPoints.equals(other.endPoints)) {
            return false;
        }
        if (this.lSPA == null ? other.lSPA != null : !this.lSPA.equals(other.lSPA)) {
            return false;
        }
        return !(this.metricList == null ? other.metricList != null : !this.metricList.equals(other.metricList));
    }
}

