/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;

public class IPv4AddressEndPoint
extends EndPoint {
    private EndPointIPv4TLV endPointIPv4;

    public IPv4AddressEndPoint() {
    }

    public IPv4AddressEndPoint(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() {
        int length = 0;
        if (this.endPointIPv4 != null) {
            this.endPointIPv4.encode();
            length += this.endPointIPv4.getTotalTLVLength();
        }
        this.setLength(length);
        this.bytes = new byte[this.getLength()];
        int offset = 0;
        if (this.endPointIPv4 != null) {
            System.arraycopy(this.endPointIPv4.getTlv_bytes(), 0, this.bytes, offset, this.endPointIPv4.getTotalTLVLength());
            offset += this.endPointIPv4.getTotalTLVLength();
        }
    }

    public void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int tlvtype = PCEPTLV.getType(bytes, offset);
        int tlvlength = PCEPTLV.getTotalTLVLength(bytes, offset);
        this.setLength(tlvlength);
        if (tlvtype == 39) {
            this.endPointIPv4 = new EndPointIPv4TLV(bytes, offset);
        }
    }

    public EndPointIPv4TLV getEndPointIPv4() {
        return this.endPointIPv4;
    }

    public void setEndPointIPv4(EndPointIPv4TLV endPointIPv4) {
        this.endPointIPv4 = endPointIPv4;
    }
}

