/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.constructs;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPConstruct;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPErrorObject;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.RequestParameters;
import java.util.LinkedList;

public class ErrorConstruct
extends PCEPConstruct {
    private LinkedList<RequestParameters> requestIdList = new LinkedList();
    private LinkedList<PCEPErrorObject> errorObjList = new LinkedList();

    public ErrorConstruct() {
    }

    public ErrorConstruct(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        this.decode(bytes, offset);
    }

    @Override
    public void encode() throws PCEPProtocolViolationException {
        int i;
        int i2;
        int len = 0;
        for (i2 = 0; i2 < this.requestIdList.size(); ++i2) {
            this.requestIdList.get(i2).encode();
            len += this.requestIdList.get(i2).getLength();
        }
        for (i2 = 0; i2 < this.errorObjList.size(); ++i2) {
            this.errorObjList.get(i2).encode();
            len += this.errorObjList.get(i2).getLength();
        }
        this.setLength(len);
        this.bytes = new byte[len];
        int offset = 0;
        for (i = 0; i < this.requestIdList.size(); ++i) {
            System.arraycopy(this.requestIdList.get(i).getBytes(), 0, this.bytes, offset, this.requestIdList.get(i).getLength());
            offset += this.requestIdList.get(i).getLength();
        }
        for (i = 0; i < this.errorObjList.size(); ++i) {
            System.arraycopy(this.errorObjList.get(i).getBytes(), 0, this.bytes, offset, this.errorObjList.get(i).getLength());
            offset += this.errorObjList.get(i).getLength();
        }
    }

    private void decode(byte[] bytes, int offset) throws PCEPProtocolViolationException {
        int len = 0;
        int max_offset = bytes.length;
        if (offset >= max_offset) {
            log.warn("Empty Notify construct!!!");
            throw new PCEPProtocolViolationException();
        }
        int oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 2) {
            RequestParameters rp;
            try {
                rp = new RequestParameters(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.requestIdList.add(rp);
            len += rp.getLength();
            if ((offset += rp.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        oc = PCEPObject.getObjectClass(bytes, offset);
        while (oc == 13) {
            PCEPErrorObject perror;
            try {
                perror = new PCEPErrorObject(bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                log.warn("Malformed METRIC Object found");
                throw new PCEPProtocolViolationException();
            }
            this.errorObjList.add(perror);
            len += perror.getLength();
            if ((offset += perror.getLength()) >= max_offset) {
                this.setLength(len);
                return;
            }
            oc = PCEPObject.getObjectClass(bytes, offset);
        }
        this.setLength(len);
    }

    public LinkedList<RequestParameters> getRequestIdList() {
        return this.requestIdList;
    }

    public void setRequestIdList(LinkedList<RequestParameters> requestIdList) {
        this.requestIdList = requestIdList;
    }

    public LinkedList<PCEPErrorObject> getErrorObjList() {
        return this.errorObjList;
    }

    public void setErrorObjList(LinkedList<PCEPErrorObject> errorObjList) {
        this.errorObjList = errorObjList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.errorObjList == null ? 0 : this.errorObjList.hashCode());
        result = 31 * result + (this.requestIdList == null ? 0 : this.requestIdList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorConstruct other = (ErrorConstruct)obj;
        if (this.errorObjList == null ? other.errorObjList != null : !this.errorObjList.equals(other.errorObjList)) {
            return false;
        }
        return !(this.requestIdList == null ? other.requestIdList != null : !this.requestIdList.equals(other.requestIdList));
    }
}

