/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.pcep.objects.tlvs.PathReservationTLV;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.util.Analysis;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessorThread
extends Thread {
    private Analysis idleTime;
    private Analysis procTime;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestQueue;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue;
    private boolean running;
    private Logger log;
    private ParentPCERequestManager cpcerm;
    private Inet4Address source;
    private Inet4Address dest;
    private boolean isChildPCE;
    private boolean isMultilayer = false;
    private boolean analyzeRequestTime;
    private boolean useMaxReqTime = false;
    private double maxProcTime;
    private long numReqProcessed = 0L;
    private long numAnswersSent = 0L;
    private long numNoPathOLSent = 0L;

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime) {
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.log = LoggerFactory.getLogger("PCEServer");
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
        } else {
            analyzeRequestTime = false;
        }
    }

    @Override
    public void run() {
        long timePreNanos = System.nanoTime();
        while (this.running) {
            ComputingRequest pathCompReq;
            block4: {
                this.log.info("Waiting for a new Computing Request to process");
                try {
                    double idleTimeV;
                    pathCompReq = this.pathComputingRequestQueue.take();
                    if (!this.analyzeRequestTime || !((idleTimeV = (double)(System.nanoTime() - timePreNanos) / 1000000.0) < 20000.0)) break block4;
                    this.idleTime.analyze(idleTimeV);
                }
                catch (InterruptedException e) {
                    this.log.warn("There is no path to compute");
                    e.printStackTrace();
                    break;
                }
            }
            long timeIniNanos = System.nanoTime();
            if (pathCompReq.getRequestList().size() == 1) {
                this.log.info("Processing New Path Computing request, id: " + pathCompReq.getRequestList().get(0).toString());
            }
            long sourceIF = 0L;
            long l = 0L;
        }
    }

    public Analysis getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Analysis idleTime) {
        this.idleTime = idleTime;
    }

    public Analysis getProcTime() {
        return this.procTime;
    }

    public void setProcTime(Analysis procTime) {
        this.procTime = procTime;
    }

    private void trappingResponse(ComputingResponse resp, long sourceIF, long destIF) {
        this.log.info("First ERO SubObject type " + resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().getFirst().getClass());
        this.log.info("Second ERO SubObject type " + resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().get(1).getClass());
        this.log.info("Last ERO SubObject type " + resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().getLast().getClass());
        Inet4Address firstIP = ((UnnumberIfIDEROSubobject)resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().getFirst()).getRouterID();
        EROSubobject label = resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().get(1);
        resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().add(0, label);
        UnnumberIfIDEROSubobject firsteroso = new UnnumberIfIDEROSubobject();
        firsteroso.setRouterID(firstIP);
        firsteroso.setInterfaceID(sourceIF);
        firsteroso.setLoosehop(false);
        resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().add(0, firsteroso);
        int size = resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().size();
        Inet4Address lastIP = ((IPv4prefixEROSubobject)resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().getLast()).getIpv4address();
        resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().removeLast();
        UnnumberIfIDEROSubobject lasteroso = new UnnumberIfIDEROSubobject();
        lasteroso.setRouterID(lastIP);
        lasteroso.setInterfaceID(destIF);
        lasteroso.setLoosehop(false);
        resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().add(lasteroso);
        resp.getResponseList().get(0).getPath(0).getEro().getEROSubobjectList().add(label);
    }

    private void sendNoPath(ComputingRequest pathCompReq) {
        this.log.info("SENDInd no path ID" + pathCompReq.getRequestList().getFirst().getRequestParameters().requestID);
        ComputingResponse m_resp = new ComputingResponse();
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(pathCompReq.getRequestList().getFirst().getRequestParameters().requestID);
        response.setRequestParameters(rp);
        NoPath noPath = new NoPath();
        noPath.setNatureOfIssue(0);
        NoPathTLV noPathTLV = new NoPathTLV();
        noPath.setNoPathTLV(noPathTLV);
        noPathTLV.setPCEunavailable(true);
        response.setNoPath(noPath);
        m_resp.addResponse(response);
        try {
            m_resp.encode();
            pathCompReq.getOut().write(m_resp.getBytes());
            pathCompReq.getOut().flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (PCEPProtocolViolationException e3) {
            e3.printStackTrace();
        }
        this.log.error("No path sent... should we send");
    }

    public double getMaxProcTime() {
        return this.maxProcTime;
    }

    public PCEPNotification createNotificationMessage(ComputingResponse resp, long timer) {
        this.log.info("Timer " + timer);
        PCEPNotification notificationMsg = new PCEPNotification();
        Notify notify = new Notify();
        Notification notif = new Notification();
        notif.setNotificationType(121);
        LinkedList<Notification> notificationList = new LinkedList<Notification>();
        PathReservationTLV pathReservationTLV = new PathReservationTLV();
        pathReservationTLV.setERO(resp.getResponseList().getFirst().getPathList().getFirst().getEro());
        boolean bidirect = resp.getResponseList().getFirst().getRequestParameters().isBidirect();
        pathReservationTLV.setTime(timer);
        pathReservationTLV.setBidirectional(bidirect);
        notif.setNotificationTLV(pathReservationTLV);
        notificationList.add(notif);
        notify.setNotificationList(notificationList);
        notificationMsg.addNotify(notify);
        return notificationMsg;
    }
}

