/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.RequestProcessorThread;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.SVECConstruct;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.MaxRequestTimeTLV;
import es.tid.pce.server.ParentPCERequestManager;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcher {
    private final int nThreads;
    private final RequestProcessorThread[] threads;
    private Lock numOPsLock;
    private Logger log = LoggerFactory.getLogger("PCEServer");
    private Hashtable<Long, ComputingRequest> pendingRequestList;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestQueue;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue;

    public RequestDispatcher(int nThreads, ParentPCERequestManager cpcerm, boolean analyzeRequestTime) {
        this.nThreads = nThreads;
        this.pathComputingRequestQueue = new LinkedBlockingQueue();
        this.pathComputingRequestRetryQueue = new LinkedBlockingQueue();
        this.pendingRequestList = new Hashtable();
        this.threads = new RequestProcessorThread[nThreads];
        this.numOPsLock = new ReentrantLock();
        for (int i = 0; i < this.nThreads; ++i) {
            this.log.info("Starting Request Processor Thread");
            this.threads[i] = new RequestProcessorThread(this.pathComputingRequestQueue, cpcerm, this.pathComputingRequestRetryQueue, analyzeRequestTime);
            this.threads[i].setPriority(10);
            this.threads[i].start();
        }
    }

    public void dispathRequests(PCEPRequest reqMessage, DataOutputStream out) {
        this.dispathRequests(reqMessage, out, null);
    }

    public void dispathRequests(PCEPInitiate iniMessage, DataOutputStream out) {
        this.log.info("Dispatching Request from Initiate message!");
        ComputingRequest cr = new ComputingRequest();
        cr.setOut(out);
        LinkedList<Request> requestList = new LinkedList<Request>();
        Request req = new Request();
        ObjectiveFunction of = new ObjectiveFunction();
        of.setOFcode(1002);
        req.setObjectiveFunction(of);
        req.setEndPoints(iniMessage.getPcepIntiatedLSPList().get(0).getEndPoint());
        req.setBandwidth(iniMessage.getPcepIntiatedLSPList().get(0).getBandwidth());
        RequestParameters reqparams = new RequestParameters();
        reqparams.setRequestID(iniMessage.getPcepIntiatedLSPList().get(0).getLsp().getLspId());
        req.setRequestParameters(reqparams);
        requestList.add(req);
        cr.setRequestList(requestList);
        cr.setTimeStampNs(System.nanoTime());
        cr.setMaxTimeInPCE(120000L);
        cr.getEcodingType(12);
        this.pathComputingRequestQueue.add(cr);
    }

    public void dispathRequests(PCEPInitiate iniMessage, DataOutputStream out, Inet4Address remotePCEId) {
        this.log.info("Dispatching Initiate message");
        ComputingRequest cr = new ComputingRequest();
        cr.setOut(out);
        LinkedList<Request> requestList = new LinkedList<Request>();
        Request req = new Request();
        ObjectiveFunction of = new ObjectiveFunction();
        of.setOFcode(1002);
        req.setObjectiveFunction(of);
        req.setEndPoints(iniMessage.getPcepIntiatedLSPList().get(0).getEndPoint());
        req.setBandwidth(iniMessage.getPcepIntiatedLSPList().get(0).getBandwidth());
        RequestParameters reqparams = new RequestParameters();
        reqparams.setRequestID(iniMessage.getPcepIntiatedLSPList().get(0).getLsp().getLspId());
        req.setRequestParameters(reqparams);
        requestList.add(req);
        cr.setIniLSP(iniMessage.getPcepIntiatedLSPList().get(0));
        cr.setRequestList(requestList);
        cr.setTimeStampNs(System.nanoTime());
        cr.setMaxTimeInPCE(120000L);
        cr.getEcodingType(12);
        this.pathComputingRequestQueue.add(cr);
    }

    public void dispathRequests(PCEPRequest reqMessage, DataOutputStream out, Inet4Address remotePCEId) {
        block15: {
            block14: {
                int i;
                if (out == null) {
                    this.log.error("OUT ESTA A NULL!!!!");
                }
                LinkedList<Request> reqList = reqMessage.getRequestList();
                this.log.debug("There are " + reqMessage.getRequestList().size() + " requests");
                if (reqMessage.getSvecList().size() == 0) break block14;
                this.log.debug("SVEC is present!");
                int numRequests = 0;
                Hashtable<Long, Request> hashReqList = new Hashtable<Long, Request>();
                for (i = 0; i < reqList.size(); ++i) {
                    hashReqList.put(new Long(reqList.get(i).getRequestParameters().getRequestID()), reqList.get(i));
                }
                this.log.debug("TAM DE  hashReqList ES " + hashReqList.size());
                for (i = 0; i < reqMessage.getSvecList().size(); ++i) {
                    this.log.debug("SVEC begins");
                    SVECConstruct svecc = reqMessage.getSvecList().get(i);
                    if (svecc.getSvec().getRequestIDlist().size() == 0) continue;
                    ComputingRequest cr = new ComputingRequest();
                    cr.setRequestList(new LinkedList<Request>());
                    cr.setOut(out);
                    cr.setSvec(svecc);
                    LinkedList<Long> reqIDlist = reqMessage.getSvecList().get(i).getSvec().getRequestIDlist();
                    for (int j = 0; j < reqIDlist.size(); ++j) {
                        long reqId = reqIDlist.get(j);
                        Request req = (Request)hashReqList.remove(reqId);
                        if (req != null) {
                            cr.getRequestList().add(req);
                            ++numRequests;
                            continue;
                        }
                        this.pendingRequestList.put(reqId, cr);
                    }
                    this.pathComputingRequestQueue.add(cr);
                }
                if (hashReqList.size() == 0) break block15;
                Enumeration enumReq = hashReqList.elements();
                while (enumReq.hasMoreElements()) {
                    ComputingRequest cr = new ComputingRequest();
                    cr.setOut(out);
                    LinkedList<Request> req = new LinkedList<Request>();
                    req.add((Request)enumReq.nextElement());
                    cr.setRequestList(req);
                    this.pathComputingRequestQueue.add(cr);
                }
                break block15;
            }
            if (reqMessage.getRequestList().size() == 1) {
                MaxRequestTimeTLV reqTLV;
                this.log.info("Dispatching Request!");
                ComputingRequest cr = new ComputingRequest();
                cr.setOut(out);
                if (remotePCEId != null) {
                    cr.setRemotePCEId(remotePCEId);
                }
                cr.setRequestList(reqMessage.getRequestList());
                cr.setTimeStampNs(System.nanoTime());
                if (reqMessage.getMonitoring() != null) {
                    cr.setMonitoring(reqMessage.getMonitoring());
                }
                if (reqMessage.getPccReqId() != null) {
                    cr.setPccReqId(reqMessage.getPccReqId());
                }
                if ((reqTLV = reqMessage.getRequestList().getFirst().getRequestParameters().getMaxRequestTimeTLV()) != null) {
                    cr.setMaxTimeInPCE(reqTLV.getMaxRequestTime());
                } else {
                    cr.setMaxTimeInPCE(120000L);
                }
                this.pathComputingRequestQueue.add(cr);
            } else {
                this.log.info("The number of requests is " + reqMessage.getRequestList().size());
                for (int i = 0; i < reqMessage.getRequestList().size(); ++i) {
                    this.log.info("Dispatching Request " + i + "th request");
                    ComputingRequest cr = new ComputingRequest();
                    cr.setOut(out);
                    LinkedList<Request> requestList = new LinkedList<Request>();
                    requestList.add(reqMessage.getRequestList().get(i));
                    cr.setRequestList(requestList);
                    this.pathComputingRequestQueue.add(cr);
                }
            }
        }
    }

    public RequestProcessorThread[] getThreads() {
        return this.threads;
    }

    public void addComputingRequestToRetryQueue(ComputingRequest compreq) {
        this.pathComputingRequestRetryQueue.add(compreq);
    }

    public synchronized void moveRetryQueueToComputingRequestQueue() {
        int numRetryReq = this.pathComputingRequestRetryQueue.size();
        for (int i = 0; i < numRetryReq; ++i) {
            try {
                this.pathComputingRequestQueue.add(this.pathComputingRequestRetryQueue.take());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int queueSize() {
        return this.pathComputingRequestQueue.size();
    }

    public int retryQueueSize() {
        return this.pathComputingRequestRetryQueue.size();
    }
}

