/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ReportProcessTask;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.server.delegation.DelegationManager;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import java.net.Inet4Address;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportProcessorThread
extends Thread {
    boolean running = true;
    LinkedBlockingQueue<ReportProcessTask> reportMessageQueue;
    ReportDB_Handler lspDB;
    DelegationManager dm;
    Logger log = LoggerFactory.getLogger("PCEServer");

    public ReportProcessorThread(LinkedBlockingQueue<ReportProcessTask> reportMessageQueue, ReportDB_Handler lspDB, DelegationManager dm) {
        this.lspDB = lspDB;
        this.reportMessageQueue = reportMessageQueue;
        this.dm = dm;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                ReportProcessTask reportTask = this.reportMessageQueue.take();
                this.effectivelyDispatch(reportTask);
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted Exception Captured in ReportProcessorThread");
                e.printStackTrace();
                break;
            }
        }
    }

    public void effectivelyDispatch(ReportProcessTask reportTask) {
        PCEPReport pcepReport = reportTask.getReportMessage();
        this.log.info("Received new report message: " + pcepReport.toString());
        int lspId = pcepReport.getStateReportList().get(0).getLsp().getLspId();
        this.log.info("whith ID :" + lspId);
        if (lspId != 0) {
            Inet4Address addres = pcepReport.getStateReportList().get(0).getLsp().getLspIdentifiers_tlv().getTunnelSenderIPAddress();
            Boolean isSyncOver = false;
            this.log.info("Size LSP:" + pcepReport.getStateReportList().size());
            this.log.info("Package received from adress: " + pcepReport.getStateReportList().get(0).getLsp().getLspIdentifiers_tlv().getTunnelSenderIPAddress());
            if (!isSyncOver.booleanValue()) {
                int numLSPs = pcepReport.getStateReportList().size();
                for (int j = 0; j < numLSPs; ++j) {
                    boolean syncFlag = pcepReport.getStateReportList().get(j).getLsp().isSyncFlag();
                    if (syncFlag || pcepReport.getStateReportList().get(j).getLsp().getLspId() != 0) continue;
                    isSyncOver = true;
                    this.log.info("Sync is over");
                }
            }
            this.lspDB.processReport(pcepReport);
            for (int i = 0; i < pcepReport.getStateReportList().size(); ++i) {
                this.log.info("PROCESSING REPORT");
                this.dm.processReport(pcepReport.getStateReportList().get(i), reportTask.getOut());
            }
        }
    }
}

