/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ReportProcessTask;
import es.tid.pce.computingEngine.ReportProcessorThread;
import es.tid.pce.server.delegation.DelegationManager;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDispatcher {
    private final int nThreads;
    private final ReportProcessorThread[] threads;
    private DelegationManager dm;
    private LinkedBlockingQueue<ReportProcessTask> reportMessageQueue;
    private Logger log = LoggerFactory.getLogger("PCEServer");

    public ReportDispatcher(ReportDB_Handler lspDB, int nThreads, SingleDomainLSPDB singleDomainLSPDB) {
        this.dm = new DelegationManager(singleDomainLSPDB);
        this.nThreads = nThreads;
        this.reportMessageQueue = new LinkedBlockingQueue();
        this.threads = new ReportProcessorThread[nThreads];
        for (int i = 0; i < this.nThreads; ++i) {
            this.log.info("Starting Request Processor Thread");
            this.threads[i] = new ReportProcessorThread(this.reportMessageQueue, lspDB, this.dm);
            this.threads[i].setPriority(10);
            this.threads[i].start();
        }
    }

    public void dispatchReport(ReportProcessTask pcepReport) {
        this.reportMessageQueue.add(pcepReport);
    }

    public DelegationManager getDm() {
        return this.dm;
    }

    public void setDm(DelegationManager dm) {
        this.dm = dm;
    }
}

