/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelSetField;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapLabelSet
extends LabelSetField {
    private byte[] bytesBitmap;
    private byte[] bytesBitmapReserved;
    private DWDMWavelengthLabel dwdmWavelengthLabel;
    private static final Logger log = LoggerFactory.getLogger("PCEServer");

    public BitmapLabelSet() {
        this.action = 4;
    }

    public BitmapLabelSet(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        this.length = bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
        this.dwdmWavelengthLabel = new DWDMWavelengthLabel();
        this.decodeHeader();
        this.decode();
    }

    public BitmapLabelSet(byte[] bytesBitMap) {
    }

    @Override
    public void encode() {
        int offset = 4;
        int numberBytes = this.getNumberBytes(this.numLabels);
        try {
            this.dwdmWavelengthLabel.encode();
        }
        catch (RSVPProtocolViolationException e) {
            e.printStackTrace();
        }
        int size_bytes = 8 + numberBytes;
        if (size_bytes % 4 != 0) {
            size_bytes += 4 - size_bytes % 4;
        }
        this.setLength(size_bytes);
        this.bytes = new byte[size_bytes];
        this.encodeHeader();
        System.arraycopy(this.dwdmWavelengthLabel.getBytes(), 0, this.bytes, offset, 4);
        System.arraycopy(this.bytesBitmap, 0, this.bytes, offset += 4, numberBytes);
        for (int i = offset += numberBytes; i < size_bytes; ++i) {
            this.bytes[i] = 0;
        }
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        int offset = 4;
        try {
            this.dwdmWavelengthLabel.decode(this.bytes, offset);
        }
        catch (RSVPProtocolViolationException e) {
            e.printStackTrace();
        }
        int numberBytes = this.getNumberBytes(this.numLabels);
        this.bytesBitmap = new byte[numberBytes];
        System.arraycopy(this.bytes, offset += 4, this.bytesBitmap, 0, numberBytes);
    }

    public byte[] getBytesBitmapReserved() {
        return this.bytesBitmapReserved;
    }

    public DWDMWavelengthLabel getDwdmWavelengthLabel() {
        return this.dwdmWavelengthLabel;
    }

    public void setBytesBitmapReserved(byte[] bytesBitmapReserved) {
        this.bytesBitmapReserved = bytesBitmapReserved;
    }

    public void setDwdmWavelengthLabel(DWDMWavelengthLabel dwdmWavelengthLabel) {
        this.dwdmWavelengthLabel = dwdmWavelengthLabel;
    }

    public byte[] getBytesBitMap() {
        return this.bytesBitmap;
    }

    public void createBytesBitMap(byte[] bytesBitMap) {
        this.bytesBitmap = new byte[bytesBitMap.length];
        System.arraycopy(bytesBitMap, 0, this.bytesBitmap, 0, bytesBitMap.length);
    }

    public void arraycopyBytesBitMap(byte[] bytesBitMap) {
        System.arraycopy(bytesBitMap, 0, this.bytesBitmap, 0, bytesBitMap.length);
    }

    public void arraycopyReservedBytesBitMap(byte[] bytesBitMap) {
        if (this.bytesBitmapReserved == null) {
            this.initializeReservation(bytesBitMap);
        }
        System.arraycopy(bytesBitMap, 0, this.bytesBitmapReserved, 0, bytesBitMap.length);
    }

    public void initializeReservation(byte[] bytesBitMap) {
        byte[] zeros = new byte[bytesBitMap.length];
        for (int i = 0; i < this.bytesBitmap.length; ++i) {
            zeros[i] = 0;
        }
        if (this.bytesBitmapReserved == null) {
            this.bytesBitmapReserved = new byte[bytesBitMap.length];
        }
        System.arraycopy(zeros, 0, this.bytesBitmapReserved, 0, bytesBitMap.length);
    }

    public void arraycopyBytesBitMap(byte[] bytesBitMap, int lambdaIni, int lambdaEnd) {
        System.arraycopy(bytesBitMap, lambdaIni, this.bytesBitmap, lambdaIni, lambdaEnd - lambdaIni);
    }

    public void createBytesBitMapRes(byte[] bytesBitMapRes) {
        this.bytesBitmapReserved = new byte[bytesBitMapRes.length];
        System.arraycopy(bytesBitMapRes, 0, this.bytesBitmapReserved, 0, bytesBitMapRes.length);
    }

    public void setReservation(int M, int N) {
        for (int i = N - M; i < N + M; ++i) {
            ByteHandler.BoolToBuffer(i, true, this.bytesBitmapReserved);
        }
    }

    public void setBytesBitmap(byte[] bytesBitmap) {
        this.bytesBitmap = bytesBitmap;
    }

    private boolean equalsBytes(byte[] bytes1, byte[] bytes2) {
        for (int i = 0; i < bytes1.length; ++i) {
            if ((bytes1[i] | bytes2[i]) == bytes1[i]) continue;
            return false;
        }
        return true;
    }

    public int getNumberBytes() {
        return this.bytesBitmap.length;
    }

    public int getNumberBytes(int num) {
        int numberBytes = num / 8;
        if (numberBytes * 8 < num) {
            ++numberBytes;
        }
        return numberBytes;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.dwdmWavelengthLabel.equals(((BitmapLabelSet)obj).getDwdmWavelengthLabel())) {
            return this.equalsBytes(this.bytesBitmap, ((BitmapLabelSet)obj).getBytesBitMap());
        }
        return false;
    }

    @Override
    public String toString() {
        int i;
        String ret = "";
        if (this.dwdmWavelengthLabel != null) {
            ret = ret + "n: " + String.valueOf(this.dwdmWavelengthLabel.getN()) + " ,Grid: " + this.dwdmWavelengthLabel.getGrid() + " cs: " + this.dwdmWavelengthLabel.getChannelSpacing() + "\r\n";
        }
        if (this.bytesBitmap != null) {
            ret = ret + "Bytes Bitmap: ";
            for (i = 0; i < this.bytesBitmap.length; ++i) {
                ret = (this.bytesBitmap[i] & 0xFF) <= 15 ? ret + "0" + Integer.toHexString(this.bytesBitmap[i] & 0xFF) : ret + Integer.toHexString(this.bytesBitmap[i] & 0xFF);
            }
        }
        if (this.bytesBitmapReserved != null) {
            ret = ret + "\r\n";
            ret = ret + "Bytes Reserved Bitmap: ";
            for (i = 0; i < this.bytesBitmapReserved.length; ++i) {
                ret = (this.bytesBitmapReserved[i] & 0xFF) <= 15 ? ret + "0" + Integer.toHexString(this.bytesBitmapReserved[i] & 0xFF) : ret + Integer.toHexString(this.bytesBitmapReserved[i] & 0xFF);
            }
        }
        ret = ret + "\r\n";
        return ret;
    }

    public int getSumaBits() {
        int sumBytesBitmap = 0;
        for (int i = 0; i < this.bytesBitmap.length * 8; ++i) {
            if ((this.bytesBitmap[i / 8] & 128 >> i % 8) != 128 >> i % 8) continue;
            ++sumBytesBitmap;
        }
        return sumBytesBitmap;
    }

    public int getNumConsecutiveEqualBits() {
        int sum = 0;
        int sumaTotal = 0;
        for (int i = 0; i < this.bytesBitmap.length * 8; ++i) {
            if ((~this.bytesBitmap[i / 8] & 128 >> i % 8) == 128 >> i % 8) {
                ++sum;
                continue;
            }
            if (sum <= sumaTotal) continue;
            sumaTotal = sum;
            sum = 0;
        }
        if (sum > sumaTotal) {
            sumaTotal = sum;
            sum = 0;
        }
        log.debug("Numero de bits libres consecutivos : " + sumaTotal);
        return sumaTotal;
    }

    public void resetBitmap() {
        log.debug("Reseting bitmap");
        for (int i = 0; i < this.bytesBitmap.length * 8; ++i) {
            this.bytesBitmap[i / 8] = 0;
        }
    }

    public void changeSignBitmap() {
        for (int i = 0; i < this.bytesBitmap.length; ++i) {
            this.bytesBitmap[i] = (byte)(~this.bytesBitmap[i] & 0xFF);
        }
    }

    @Override
    public LabelSetField duplicate() {
        BitmapLabelSet bls = new BitmapLabelSet();
        if (this.bytesBitmap != null) {
            bls.bytesBitmap = (byte[])this.bytesBitmap.clone();
        }
        if (this.bytesBitmapReserved != null) {
            bls.bytesBitmapReserved = (byte[])this.bytesBitmapReserved.clone();
        }
        bls.numLabels = this.numLabels;
        bls.dwdmWavelengthLabel = this.getDwdmWavelengthLabel().duplicate();
        return bls;
    }
}

