/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class RemoteASNumber
extends OSPFSubTLV {
    private Inet4Address remoteASNumber;

    public RemoteASNumber() {
        this.setTLVType(21);
    }

    public RemoteASNumber(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.remoteASNumber.getAddress(), 0, this.tlv_bytes, offset, 4);
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 4) {
            throw new MalformedOSPFSubTLVException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.remoteASNumber = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedOSPFSubTLVException();
        }
    }

    public Inet4Address getRemoteASNumber() {
        return this.remoteASNumber;
    }

    public void setRemoteASNumber(Inet4Address remoteASNumber) {
        this.remoteASNumber = remoteASNumber;
    }

    @Override
    public boolean equals(Object obj) {
        return this.remoteASNumber.equals(((RemoteASNumber)obj).getRemoteASNumber());
    }

    public String toString() {
        String ret = "remoteASNumber: " + this.remoteASNumber.toString();
        return ret;
    }
}

