/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class PortLabelRestriction
extends OSPFSubTLV {
    private int matrixID;
    private int restrictionType;
    private int reservedOrParameter;
    private long additionalRestrictionParameters;

    public PortLabelRestriction() {
        this.setTLVType(100);
    }

    public PortLabelRestriction(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        if (this.restrictionType == 1) {
            this.setTLVValueLength(4);
        } else {
            this.setTLVValueLength(8);
        }
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.matrixID & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.restrictionType & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.reservedOrParameter >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.reservedOrParameter & 0xFF);
        if (this.restrictionType != 1) {
            this.tlv_bytes[offset += 4] = (byte)(this.additionalRestrictionParameters >> 24 & 0xFFL);
            this.tlv_bytes[offset + 1] = (byte)(this.additionalRestrictionParameters >> 16 & 0xFFL);
            this.tlv_bytes[offset + 2] = (byte)(this.additionalRestrictionParameters >> 8 & 0xFFL);
            this.tlv_bytes[offset + 3] = (byte)(this.additionalRestrictionParameters & 0xFFL);
        }
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        int offset = 4;
        this.matrixID = this.tlv_bytes[offset];
        this.restrictionType = this.tlv_bytes[offset + 1];
        this.reservedOrParameter = this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
        if (this.getTLVValueLength() != 4 && this.restrictionType == 1) {
            throw new MalformedOSPFSubTLVException();
        }
        if (this.getTLVValueLength() != 8) {
            throw new MalformedOSPFSubTLVException();
        }
        if (this.restrictionType != 1) {
            this.additionalRestrictionParameters = this.tlv_bytes[offset += 4] << 24 & 0xFF000000 | this.tlv_bytes[offset + 1] << 16 & 0xFF0000 | this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
        }
    }

    public int getMatrixID() {
        return this.matrixID;
    }

    public void setMatrixID(int matrixID) {
        this.matrixID = matrixID;
    }

    public int getRestrictionType() {
        return this.restrictionType;
    }

    public void setRestrictionType(int restrictionType) {
        this.restrictionType = restrictionType;
    }

    public int getReservedOrParameter() {
        return this.reservedOrParameter;
    }

    public void setReservedOrParameter(int reservedOrParameter) {
        this.reservedOrParameter = reservedOrParameter;
    }

    public long getAdditionalRestrictionParameters() {
        return this.additionalRestrictionParameters;
    }

    public void setAdditionalRestrictionParameters(long additionalRestrictionParameters) {
        this.additionalRestrictionParameters = additionalRestrictionParameters;
    }

    public String toString() {
        return "PortLabelRestriction [matrixID=" + this.matrixID + ", restrictionType=" + this.restrictionType + ", reservedOrParameter=" + this.reservedOrParameter + ", additionalRestrictionParameters=" + this.additionalRestrictionParameters + "]";
    }
}

