/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSPFSubTLV {
    protected int TLVType;
    private int TLVValueLength;
    protected int TotalTLVLength;
    protected byte[] tlv_bytes;
    protected static final Logger log = LoggerFactory.getLogger("PCEPParser");

    public OSPFSubTLV() {
    }

    public OSPFSubTLV(byte[] bytes, int offset) {
        this.TLVType = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        this.TLVValueLength = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.TotalTLVLength = this.TLVValueLength + 4;
        if (this.TotalTLVLength % 4 != 0) {
            this.TotalTLVLength = this.TotalTLVLength + 4 - this.TotalTLVLength % 4;
        }
        this.tlv_bytes = new byte[this.TotalTLVLength];
        System.arraycopy(bytes, offset, this.tlv_bytes, 0, this.TotalTLVLength);
    }

    protected void encodeHeader() {
        this.tlv_bytes[0] = (byte)(this.TLVType >>> 8 & 0xFF);
        this.tlv_bytes[1] = (byte)(this.TLVType & 0xFF);
        this.tlv_bytes[2] = (byte)(this.TLVValueLength >>> 8 & 0xFF);
        this.tlv_bytes[3] = (byte)(this.TLVValueLength & 0xFF);
    }

    public int getTLVValueLength() {
        return this.TLVValueLength;
    }

    public int getTotalTLVLength() {
        return this.TotalTLVLength;
    }

    public static int getTotalTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        if ((len += 4) % 4 != 0) {
            len = len + 4 - len % 4;
        }
        return len;
    }

    public static int getTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        return typ;
    }

    public int getTLVType() {
        return this.TLVType;
    }

    protected void setTLVType(int tLVType) {
        this.TLVType = tLVType;
    }

    public byte[] getTlv_bytes() {
        return this.tlv_bytes;
    }

    protected void setTlv_bytes(byte[] tlv_bytes) {
        this.tlv_bytes = tlv_bytes;
    }

    protected void setTLVValueLength(int TLVValueLength) {
        this.TLVValueLength = TLVValueLength;
        this.TotalTLVLength = TLVValueLength + 4;
        if (this.TotalTLVLength % 4 != 0) {
            this.TotalTLVLength = this.TotalTLVLength + 4 - this.TotalTLVLength % 4;
        }
    }

    public abstract void encode() throws MalformedOSPFSubTLVException;

    protected abstract void decode() throws MalformedOSPFSubTLVException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.TLVType;
        result = 31 * result + this.TLVValueLength;
        result = 31 * result + this.TotalTLVLength;
        result = 31 * result + Arrays.hashCode(this.tlv_bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OSPFSubTLV other = (OSPFSubTLV)obj;
        if (this.TLVType != other.TLVType) {
            return false;
        }
        if (this.TLVValueLength != other.TLVValueLength) {
            return false;
        }
        if (this.TotalTLVLength != other.TotalTLVLength) {
            return false;
        }
        return Arrays.equals(this.tlv_bytes, other.tlv_bytes);
    }
}

