/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class LinkID
extends OSPFSubTLV {
    private Inet4Address linkID;

    public LinkID() {
        this.setTLVType(2);
    }

    public LinkID(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.linkID.getAddress(), 0, this.tlv_bytes, offset, 4);
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 4) {
            throw new MalformedOSPFSubTLVException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.linkID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedOSPFSubTLVException();
        }
    }

    public Inet4Address getLinkID() {
        return this.linkID;
    }

    public void setLinkID(Inet4Address linkID) {
        this.linkID = linkID;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "LinkId: " + this.linkID.toString();
    }
}

