/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;

public class LabelTypeTLV
extends OSPFSubTLV {
    private int priority;
    private long reserved;
    private int action;
    private int numLabels;
    private int length;
    private int grid;
    private int channelSpacing;
    private int identifier;
    private int n;
    private byte[] bytesBitmap;

    public LabelTypeTLV() {
        this.setTLVType(1);
        this.numLabels = 0;
    }

    public LabelTypeTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.numLabels = 0;
        this.decode();
    }

    @Override
    public void encode() {
        int valueLength = 12 + this.getNumberBytes(this.numLabels);
        this.setTLVValueLength(valueLength);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.priority & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.reserved >> 16 & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.reserved >> 8 & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.reserved & 0xFFL);
        this.tlv_bytes[++offset] = (byte)(this.action << 4 | this.numLabels >> 8 & 0xF);
        this.tlv_bytes[++offset] = (byte)(this.numLabels & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.length >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.length & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.grid << 5 | this.channelSpacing << 1 | this.identifier >>> 8);
        this.tlv_bytes[++offset] = (byte)(this.identifier & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.n >> 8 & 0xFF);
        this.tlv_bytes[++offset] = (byte)(this.n & 0xFF);
        int numberBytes = this.getNumberBytes(this.numLabels);
        System.arraycopy(this.bytesBitmap, 0, this.tlv_bytes, ++offset, numberBytes);
        offset += numberBytes;
    }

    @Override
    public void decode() {
        int offset = 4;
        this.priority = this.tlv_bytes[offset] & 0xFF;
        ++offset;
        this.reserved = 0L;
        for (int k = 0; k < 3; ++k) {
            this.reserved = this.reserved << 8 | (long)this.tlv_bytes[k + offset] & 0xFFL;
        }
        this.action = (this.tlv_bytes[offset += 3] & 0xF0) >> 4;
        this.numLabels = (this.tlv_bytes[offset] & 0xF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        this.length = (this.tlv_bytes[offset += 2] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        this.grid = (this.tlv_bytes[offset += 2] & 0xE0) >>> 5;
        this.channelSpacing = (this.tlv_bytes[offset] & 0x1E) >>> 1;
        this.identifier = (this.tlv_bytes[offset] & 1) << 8 | this.tlv_bytes[offset + 1] & 0xFF;
        this.n = 0;
        this.n = (this.tlv_bytes[offset += 2] & 0xFF) << 8 | this.tlv_bytes[offset + 1] & 0xFF | this.n;
        String str = "";
        for (int i = offset; i < offset + 2; ++i) {
            str = (this.tlv_bytes[i] & 0xFF) <= 15 ? str + "0" + Integer.toHexString(this.tlv_bytes[i] & 0xFF) : str + Integer.toHexString(this.tlv_bytes[i] & 0xFF);
        }
        log.info("Los bytes de n son: " + str + ".");
        int numberBytes = this.getNumberBytes(this.numLabels);
        this.bytesBitmap = new byte[numberBytes];
        System.arraycopy(this.tlv_bytes, offset += 2, this.bytesBitmap, 0, numberBytes);
    }

    public int getNumberBytes(int num) {
        int numberBytes = num / 8;
        if (numberBytes * 8 < num) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public LabelTypeTLV duplicate() {
        LabelTypeTLV lt = new LabelTypeTLV();
        lt.setPriority(this.priority);
        lt.setReserved(this.reserved);
        lt.setAction(this.action);
        lt.setNumLabels(this.numLabels);
        lt.setLength(this.length);
        lt.setGrid(this.grid);
        lt.setChannelSpacing(this.channelSpacing);
        lt.setIdentifier(this.identifier);
        lt.setN(this.n);
        lt.setBytesBitmap((byte[])this.getBytesBitmap().clone());
        return lt;
    }

    public byte[] getBytesBitmap() {
        return this.bytesBitmap;
    }

    public void setBytesBitmap(byte[] bytesBitmap) {
        this.bytesBitmap = bytesBitmap;
    }

    public String toString() {
        String str = "[LabelTypeTLV \n Priority: " + this.priority + "| Reserved: " + this.reserved + "| Action: " + this.action + "\n NumLabel: " + this.numLabels + "| Length:  " + this.length + "| Grid:   " + this.grid + "\n CS:         " + this.channelSpacing + "| Id:       " + this.identifier + "| n:      " + (short)this.n + "\n BitMap: ";
        for (int i = 0; i < this.bytesBitmap.length; ++i) {
            str = (this.bytesBitmap[i] & 0xFF) <= 15 ? str + "0" + Integer.toHexString(this.bytesBitmap[i] & 0xFF) : str + Integer.toHexString(this.bytesBitmap[i] & 0xFF);
        }
        str = str + ">";
        return str;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setReserved(long reserved) {
        this.reserved = reserved;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public void setNumLabels(int numLabels) {
        this.numLabels = numLabels;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getGrid() {
        return this.grid;
    }

    public void setGrid(int grid) {
        this.grid = grid;
    }

    public int getChannelSpacing() {
        return this.channelSpacing;
    }

    public void setChannelSpacing(int channelSpacing) {
        this.channelSpacing = channelSpacing;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

