/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.util.Arrays;

public class InterfaceSwitchingCapabilityDescriptor
extends OSPFSubTLV {
    private int switchingCap;
    private int encoding;
    private long[] max_LSP_BW = new long[8];

    public InterfaceSwitchingCapabilityDescriptor() {
        this.setTLVType(15);
    }

    public InterfaceSwitchingCapabilityDescriptor(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int length = 36;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.switchingCap & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.encoding & 0xFF);
        offset += 4;
        for (int i = 0; i < 8; ++i) {
            this.tlv_bytes[offset] = (byte)(this.max_LSP_BW[i] >> 24 & 0xFFL);
            this.tlv_bytes[offset + 1] = (byte)(this.max_LSP_BW[i] >> 16 & 0xFFL);
            this.tlv_bytes[offset + 2] = (byte)(this.max_LSP_BW[i] >> 8 & 0xFFL);
            this.tlv_bytes[offset + 3] = (byte)(this.max_LSP_BW[i] & 0xFFL);
            offset += 4;
        }
    }

    @Override
    protected void decode() throws MalformedOSPFSubTLVException {
        int offset = 4;
        this.switchingCap = this.tlv_bytes[offset] & 0xFF;
        this.encoding = this.tlv_bytes[offset + 1] & 0xFF;
        offset += 4;
        for (int i = 0; i < 8; ++i) {
            this.max_LSP_BW[i] = (this.tlv_bytes[offset] & 0xFF) << 24 & 0xFF000000 | (this.tlv_bytes[offset + 1] & 0xFF) << 16 & 0xFF0000 | (this.tlv_bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
            offset += 4;
        }
    }

    public int getSwitchingCap() {
        return this.switchingCap;
    }

    public void setSwitchingCap(int switchingCap) {
        this.switchingCap = switchingCap;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public void setEncoding(int encoding) {
        this.encoding = encoding;
    }

    public long[] getMax_LSP_BW() {
        return this.max_LSP_BW;
    }

    public void setMax_LSP_BW(long[] max_LSP_BW) {
        this.max_LSP_BW = max_LSP_BW;
    }

    public long getMax_LSP_BW(int i) {
        return this.max_LSP_BW[i];
    }

    public void setMax_LSP_BW(int i, long maxLSPBW) {
        this.max_LSP_BW[i] = maxLSPBW;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceSwitchingCapabilityDescriptor other = (InterfaceSwitchingCapabilityDescriptor)obj;
        if (this.encoding != other.encoding) {
            return false;
        }
        if (!Arrays.equals(this.max_LSP_BW, other.max_LSP_BW)) {
            return false;
        }
        return this.switchingCap == other.switchingCap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ISCD: swCap: ");
        if (this.switchingCap == 150) {
            sb.append("150 (LAMBDA)");
        } else {
            sb.append(this.switchingCap);
        }
        return sb.toString();
    }
}

