/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4RemoteASBRID
extends OSPFSubTLV {
    private Inet4Address iPv4RemoteASBRID;

    public IPv4RemoteASBRID() {
        this.setTLVType(22);
    }

    public IPv4RemoteASBRID(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.iPv4RemoteASBRID.getAddress(), 0, this.tlv_bytes, offset, 4);
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        if (this.getTLVValueLength() != 4) {
            throw new MalformedOSPFSubTLVException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.iPv4RemoteASBRID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedOSPFSubTLVException();
        }
    }

    public Inet4Address getIPv4RemoteASBRID() {
        return this.iPv4RemoteASBRID;
    }

    public void setIPv4RemoteASBRID(Inet4Address iPv4RemoteASBRID) {
        this.iPv4RemoteASBRID = iPv4RemoteASBRID;
    }

    @Override
    public boolean equals(Object obj) {
        return this.iPv4RemoteASBRID.equals(((IPv4RemoteASBRID)obj).getIPv4RemoteASBRID());
    }

    public String toString() {
        String ret = "IPv4RemoteASBRID: " + this.iPv4RemoteASBRID.toString();
        return ret;
    }
}

