/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv.subtlv;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.OSPFSubTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelListField;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelRangeField;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelSetField;

public class AvailableLabels
extends OSPFSubTLV {
    private LabelSetField labelSet;

    public AvailableLabels() {
        this.setTLVType(1200);
    }

    public AvailableLabels(byte[] bytes, int offset) throws MalformedOSPFSubTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() throws MalformedOSPFSubTLVException {
        if (this.labelSet == null) {
            log.warn("Label Set de Availables Labels is null");
            throw new MalformedOSPFSubTLVException();
        }
        this.labelSet.encode();
        this.setTLVValueLength(this.labelSet.getLength());
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        System.arraycopy(this.labelSet.getBytes(), 0, this.tlv_bytes, 4, this.labelSet.getLength());
    }

    @Override
    public void decode() throws MalformedOSPFSubTLVException {
        int offset = 4;
        int type = (this.getTlv_bytes()[offset] & 0xF0) >> 4;
        if (type == 0) {
            this.labelSet = new LabelListField(this.getTlv_bytes(), offset);
        } else if (type == 1) {
            this.labelSet = new LabelListField(this.getTlv_bytes(), offset);
        } else if (type == 2) {
            this.labelSet = new LabelRangeField(this.getTlv_bytes(), offset);
        } else if (type == 3) {
            this.labelSet = new LabelRangeField(this.getTlv_bytes(), offset);
        } else if (type == 4) {
            this.labelSet = new BitmapLabelSet(this.getTlv_bytes(), offset);
        }
    }

    public LabelSetField getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSetField labelSet) {
        this.labelSet = labelSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.labelSet == null ? 0 : this.labelSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvailableLabels other = (AvailableLabels)obj;
        return !(this.labelSet == null ? other.labelSet != null : !this.labelSet.equals(other.labelSet));
    }

    public String toString() {
        return this.labelSet.toString();
    }

    public AvailableLabels dublicate() {
        AvailableLabels al = new AvailableLabels();
        if (this.getLabelSet() != null) {
            al.setLabelSet(this.getLabelSet().duplicate());
        }
        return al;
    }
}

