/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2.lsa.tlv;

import es.tid.ospf.ospfv2.lsa.tlv.MalformedOSPFTLVException;
import es.tid.ospf.ospfv2.lsa.tlv.OSPFTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class RouterAddressTLV
extends OSPFTLV {
    private Inet4Address routerAddress;

    public RouterAddressTLV() {
        this.setTLVType(1);
    }

    public RouterAddressTLV(byte[] bytes, int offset) throws MalformedOSPFTLVException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        if (this.routerAddress != null) {
            System.arraycopy(this.routerAddress.getAddress(), 0, this.tlv_bytes, 4, 4);
        } else {
            this.tlv_bytes[4] = 0;
            this.tlv_bytes[5] = 0;
            this.tlv_bytes[6] = 0;
            this.tlv_bytes[7] = 0;
        }
    }

    private void decode() throws MalformedOSPFTLVException {
        if (this.getTLVValueLength() != 4) {
            log.warn("Incorrect VALUE LENGTH!!!");
            throw new MalformedOSPFTLVException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.routerAddress = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedOSPFTLVException();
        }
    }

    public Inet4Address getRouterAddress() {
        return this.routerAddress;
    }

    public void setRouterAddress(Inet4Address routerAddress) {
        this.routerAddress = routerAddress;
    }

    public String toString() {
        return "routerAddress: " + this.routerAddress.getHostAddress();
    }
}

