/*
 * Decompiled with CFR 0.152.
 */
package es.tid.ospf.ospfv2;

import es.tid.ospf.ospfv2.OSPFv2Packet;
import es.tid.ospf.ospfv2.lsa.InterASTEv2LSA;
import es.tid.ospf.ospfv2.lsa.LSA;
import es.tid.ospf.ospfv2.lsa.MalformedOSPFLSAException;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import es.tid.ospf.ospfv2.lsa.OpaqueLSA;
import java.util.LinkedList;

public class OSPFv2LinkStateUpdatePacket
extends OSPFv2Packet {
    private LinkedList<LSA> LSAlist;

    public OSPFv2LinkStateUpdatePacket() {
        this.setType(4);
        this.LSAlist = new LinkedList();
    }

    public OSPFv2LinkStateUpdatePacket(byte[] bytes, int offset) {
        super(bytes, offset);
        this.LSAlist = new LinkedList();
        int type = 0;
        int length_lsa = 0;
        int num_lsa = (bytes[offset += 24] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        offset += 4;
        for (int i = 0; i < num_lsa; ++i) {
            type = LSA.getLStype(bytes, offset);
            length_lsa = LSA.getLSlength(bytes, offset);
            if (type == 10) {
                int opaque_type = OpaqueLSA.getOpaqueType(bytes, offset);
                try {
                    if (opaque_type == 1) {
                        this.LSAlist.add(new OSPFTEv2LSA(bytes, offset));
                    } else if (opaque_type == 6) {
                        this.LSAlist.add(new InterASTEv2LSA(bytes, offset));
                    }
                }
                catch (MalformedOSPFLSAException e) {
                    e.printStackTrace();
                }
            }
            offset += length_lsa;
        }
    }

    @Override
    public void encode() {
        int len = 28;
        long num_lsas = this.LSAlist.size();
        int i = 0;
        while ((long)i < num_lsas) {
            LSA lsa = this.LSAlist.get(i);
            lsa.encode();
            len += lsa.getLength();
            ++i;
        }
        this.setLength(len);
        this.bytes = new byte[this.getLength()];
        this.encodeOSPFV2PacketHeader();
        this.bytes[24] = (byte)(num_lsas >>> 24);
        this.bytes[25] = (byte)(num_lsas >>> 16);
        this.bytes[26] = (byte)(num_lsas >>> 8);
        this.bytes[27] = (byte)num_lsas;
        int offset = 28;
        int i2 = 0;
        while ((long)i2 < num_lsas) {
            LSA lsa = this.LSAlist.get(i2);
            System.arraycopy(lsa.getLSAbytes(), 0, this.bytes, offset, lsa.getLength());
            ++i2;
        }
    }

    public LinkedList<LSA> getLSAlist() {
        return this.LSAlist;
    }

    public void setLSAlist(LinkedList<LSA> lSAlist) {
        this.LSAlist = lSAlist;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2000);
        for (LSA lsa : this.LSAlist) {
            sb.append(lsa.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

