/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class UndirectionalLinkDelayDescriptorSubTLV
extends BGP4TLVFormat {
    int delay;

    public UndirectionalLinkDelayDescriptorSubTLV() {
        this.setTLVType(1104);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            delay = 0;
        }
        if (delay > 0xFFFFFF) {
            delay = 0xFFFFFF;
        }
        this.delay = delay;
    }

    public UndirectionalLinkDelayDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = 0;
        this.tlv_bytes[offset + 1] = (byte)(this.delay >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.delay >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.delay & 0xFF);
    }

    public void decode() {
        if (this.getTLVValueLength() != 4) {
            // empty if block
        }
        int offset = 4;
        this.delay = 0;
        this.delay = this.tlv_bytes[offset + 1] << 16 & 0xFF0000 | this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public String toString() {
        return "UndirectionalLinkDelay [delay_ms=" + this.delay + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.delay;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UndirectionalLinkDelayDescriptorSubTLV other = (UndirectionalLinkDelayDescriptorSubTLV)obj;
        return this.delay == other.delay;
    }
}

