/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class OSPFRouteTypeTLV
extends BGP4TLVFormat {
    public static final int INTRA_AREA = 1;
    public static final int INTER_AREA = 2;
    public static final int EXTERNAL_1 = 3;
    public static final int EXTERNAL_2 = 4;
    public static final int NSSA_1 = 5;
    public static final int NSSA_2 = 6;
    private int route_type;

    public OSPFRouteTypeTLV() {
        int offset;
        this.setTLVType(264);
        this.setTLVValueLength(1);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int n = offset = 4;
        this.tlv_bytes[n] = (byte)(this.tlv_bytes[n] | (byte)this.getRoute_type());
    }

    public OSPFRouteTypeTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(1);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)this.route_type;
    }

    public void decode() {
        int offset = 4;
        byte type = this.tlv_bytes[offset];
        switch (type) {
            case 1: {
                this.setRoute_type(1);
            }
            case 2: {
                this.setRoute_type(2);
            }
            case 3: {
                this.setRoute_type(3);
            }
            case 4: {
                this.setRoute_type(4);
            }
            case 5: {
                this.setRoute_type(5);
            }
            case 6: {
                this.setRoute_type(6);
            }
        }
        log.debug("No such OSPF route type");
    }

    public int getRoute_type() {
        return this.route_type;
    }

    public void setRoute_type(int route_type) {
        this.route_type = route_type;
    }

    public String toString() {
        return "Route Type [route_type=" + this.route_type + "]";
    }
}

