/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class MinMaxUndirectionalLinkDelayDescriptorSubTLV
extends BGP4TLVFormat {
    int lowDelay;
    int highDelay;

    public MinMaxUndirectionalLinkDelayDescriptorSubTLV() {
        this.setTLVType(1105);
    }

    public MinMaxUndirectionalLinkDelayDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 8;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = 0;
        this.tlv_bytes[offset + 1] = (byte)(this.lowDelay >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.lowDelay >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.lowDelay & 0xFF);
        offset = 8;
        this.tlv_bytes[offset] = 0;
        this.tlv_bytes[offset + 1] = (byte)(this.highDelay >> 16 & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.highDelay >> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.highDelay & 0xFF);
    }

    public void decode() {
        if (this.getTLVValueLength() != 8) {
            // empty if block
        }
        int offset = 4;
        this.lowDelay = 0;
        this.lowDelay = this.tlv_bytes[offset + 1] << 16 & 0xFF0000 | this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
        offset = 8;
        this.highDelay = 0;
        this.highDelay = this.tlv_bytes[offset + 1] << 16 & 0xFF0000 | this.tlv_bytes[offset + 2] << 8 & 0xFF00 | this.tlv_bytes[offset + 3] & 0xFF;
    }

    public String toString() {
        return "MinMaxUndirectionalLinkDelay [low_delay_ms=" + this.lowDelay + " , high_delay_ms=" + this.highDelay + "]";
    }

    public int getLowDelay() {
        return this.lowDelay;
    }

    public void setLowDelay(int lowDelay) {
        if (lowDelay < 0) {
            lowDelay = 0;
        }
        if (lowDelay > 0xFFFFFF) {
            lowDelay = 0xFFFFFF;
        }
        this.lowDelay = lowDelay;
    }

    public int getHighDelay() {
        return this.highDelay;
    }

    public void setHighDelay(int highDelay) {
        if (highDelay < 0) {
            highDelay = 0;
        }
        if (highDelay > 0xFFFFFF) {
            highDelay = 0xFFFFFF;
        }
        this.highDelay = highDelay;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.highDelay;
        result = 31 * result + this.lowDelay;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MinMaxUndirectionalLinkDelayDescriptorSubTLV other = (MinMaxUndirectionalLinkDelayDescriptorSubTLV)obj;
        if (this.highDelay != other.highDelay) {
            return false;
        }
        return this.lowDelay == other.lowDelay;
    }
}

