/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class LinkLocalRemoteIdentifiersLinkDescriptorSubTLV
extends BGP4TLVFormat {
    private long linkLocalIdentifier;
    private long linkRemoteIdentifier;

    public LinkLocalRemoteIdentifiersLinkDescriptorSubTLV() {
        this.setTLVType(258);
    }

    public LinkLocalRemoteIdentifiersLinkDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.linkLocalIdentifier >> 24 & 0xFFL);
        this.tlv_bytes[offset + 1] = (byte)(this.linkLocalIdentifier >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.linkLocalIdentifier >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.linkLocalIdentifier & 0xFFL);
        this.tlv_bytes[offset += 4] = (byte)(this.linkRemoteIdentifier >> 24 & 0xFFL);
        this.tlv_bytes[offset + 1] = (byte)(this.linkRemoteIdentifier >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.linkRemoteIdentifier >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.linkRemoteIdentifier & 0xFFL);
    }

    protected void decode() {
        if (this.getTLVValueLength() != 8) {
            log.error("PROBLEM in Link Local/Remote Identifier");
        }
        int offset = 4;
        this.linkLocalIdentifier = (long)(this.tlv_bytes[offset] << 24) & 0xFFFFFFFFFF000000L | (long)(this.tlv_bytes[offset + 1] << 16 & 0xFF0000) | (long)(this.tlv_bytes[offset + 2] << 8 & 0xFF00) | (long)(this.tlv_bytes[offset + 3] & 0xFF);
        offset = 8;
        this.linkRemoteIdentifier = (long)(this.tlv_bytes[offset] << 24) & 0xFFFFFFFFFF000000L | (long)(this.tlv_bytes[offset + 1] << 16 & 0xFF0000) | (long)(this.tlv_bytes[offset + 2] << 8 & 0xFF00) | (long)(this.tlv_bytes[offset + 3] & 0xFF);
    }

    public long getLinkLocalIdentifier() {
        return this.linkLocalIdentifier;
    }

    public void setLinkLocalIdentifier(long linkLocalIdentifier) {
        this.linkLocalIdentifier = linkLocalIdentifier;
    }

    public long getLinkRemoteIdentifier() {
        return this.linkRemoteIdentifier;
    }

    public void setLinkRemoteIdentifier(long linkRemoteIdentifier) {
        this.linkRemoteIdentifier = linkRemoteIdentifier;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.linkLocalIdentifier ^ this.linkLocalIdentifier >>> 32);
        result = 31 * result + (int)(this.linkRemoteIdentifier ^ this.linkRemoteIdentifier >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkLocalRemoteIdentifiersLinkDescriptorSubTLV other = (LinkLocalRemoteIdentifiersLinkDescriptorSubTLV)obj;
        if (this.linkLocalIdentifier != other.linkLocalIdentifier) {
            return false;
        }
        return this.linkRemoteIdentifier == other.linkRemoteIdentifier;
    }

    public String toString() {
        String ret = "LinkIdentifiers [Local Link Identifier=" + this.linkLocalIdentifier + "\n\t\tRemote Link Identifier=" + this.linkRemoteIdentifier;
        return ret;
    }
}

