/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4NeighborAddressLinkDescriptorSubTLV
extends BGP4TLVFormat {
    Inet4Address ipv4Address;

    public IPv4NeighborAddressLinkDescriptorSubTLV() {
        this.setTLVType(260);
    }

    public IPv4NeighborAddressLinkDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        System.arraycopy(this.ipv4Address.getAddress(), 0, this.tlv_bytes, 4, 4);
    }

    public void decode() {
        if (this.getTLVValueLength() != 4) {
            // empty if block
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.ipv4Address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(Inet4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public String toString() {
        return "IPv4NeighbourAddress [ipv4Address=" + this.ipv4Address.toString() + "]";
    }
}

