/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPReachabilityInformationTLV
extends BGP4TLVFormat {
    private Inet4Address ipv4Address;
    private int prefix_length;

    public IPReachabilityInformationTLV() {
        this.setTLVType(265);
    }

    public IPReachabilityInformationTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = this.prefix_length >= 25 ? 5 : (this.prefix_length >= 17 ? 4 : (this.prefix_length >= 9 ? 3 : 2));
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)this.prefix_length;
        System.arraycopy(this.ipv4Address.getAddress(), 0, this.tlv_bytes, ++offset, len - 1);
    }

    public void decode() {
        int offset = 4;
        byte[] ip = new byte[4];
        this.prefix_length = this.tlv_bytes[offset] & 0xFF;
        ++offset;
        if (this.prefix_length >= 25) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
        } else if (this.prefix_length >= 17) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 3);
            ip[3] = 0;
        } else if (this.prefix_length >= 9) {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 2);
            ip[2] = 0;
            ip[3] = 0;
        } else {
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 1);
            ip[1] = 0;
            ip[2] = 0;
            ip[3] = 0;
        }
        try {
            this.ipv4Address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(Inet4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public int getPrefix_length() {
        return this.prefix_length;
    }

    public void setPrefix_length(int prefix_length) {
        this.prefix_length = prefix_length;
    }

    public String toString() {
        return "IPReachability [Reachability=" + this.ipv4Address.toString() + "]";
    }
}

