/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs;

import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.NodeDescriptorsSubTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class AreaIDNodeDescriptorSubTLV
extends NodeDescriptorsSubTLV {
    private Inet4Address AREA_ID;

    public AreaIDNodeDescriptorSubTLV() {
        this.setSubTLVType(514);
    }

    public AreaIDNodeDescriptorSubTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    private void decode() {
        byte[] ip = new byte[4];
        System.arraycopy(this.subtlv_bytes, 4, ip, 0, 4);
        try {
            this.AREA_ID = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void encode() {
        this.setSubTLVValueLength(4);
        this.subtlv_bytes = new byte[this.getTotalSubTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.AREA_ID.getAddress(), 0, this.subtlv_bytes, offset, 4);
    }

    public Inet4Address getAREA_ID() {
        return this.AREA_ID;
    }

    public void setAREA_ID(Inet4Address AREA_ID) {
        this.AREA_ID = AREA_ID;
    }

    public String toString() {
        return "AreaID [Area_ID=" + this.AREA_ID + "]";
    }
}

