/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class NodeNameNodeAttribTLV
extends BGP4TLVFormat {
    private byte[] name;

    public NodeNameNodeAttribTLV() {
        this.setTLVType(1026);
    }

    public NodeNameNodeAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.name.length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.name, 0, this.tlv_bytes, offset, this.name.length);
    }

    public void decode() {
        int length = this.getTLVValueLength();
        int offset = 4;
        this.name = new byte[length];
        System.arraycopy(this.tlv_bytes, offset, this.name, 0, length);
    }

    public void setName(String name) {
        char[] c = name.toCharArray();
        byte[] b = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)(c[i] & 0x7F);
        }
        System.arraycopy(b, 0, name, 0, b.length);
    }

    public void setName(byte[] name) {
        this.name = name;
    }

    public byte[] getName() {
        return this.name;
    }

    public String toString() {
        return "NODE NAME [name=" + this.getName().toString() + "]";
    }
}

