/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class NodeFlagBitsNodeAttribTLV
extends BGP4TLVFormat {
    private boolean overload_bit = false;
    private boolean attached_bit = false;
    private boolean external_bit = false;
    private boolean abr_bit = false;

    public NodeFlagBitsNodeAttribTLV() {
        this.setTLVType(1024);
    }

    public NodeFlagBitsNodeAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(1);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = 0;
        this.tlv_bytes[offset] = (byte)(this.tlv_bytes[offset] | (this.overload_bit ? -128 : 0));
        this.tlv_bytes[offset] = (byte)(this.tlv_bytes[offset] | (this.attached_bit ? 64 : 0));
        this.tlv_bytes[offset] = (byte)(this.tlv_bytes[offset] | (this.external_bit ? 32 : 0));
        this.tlv_bytes[offset] = (byte)(this.tlv_bytes[offset] | (this.abr_bit ? 16 : 0));
    }

    public void decode() {
        int offset = 4;
        int flags = this.tlv_bytes[offset] & 0xFF;
        if ((flags & 0x80) == 128) {
            this.setOverload_bit(true);
        }
        if ((flags & 0x40) == 64) {
            this.setAttached_bit(true);
        }
        if ((flags & 0x20) == 32) {
            this.setExternal_bit(true);
        }
        if ((flags & 0x10) == 16) {
            this.setAbr_bit(true);
        }
    }

    public boolean isOverload_bit() {
        return this.overload_bit;
    }

    public void setOverload_bit(boolean overload_bit) {
        this.overload_bit = overload_bit;
    }

    public boolean isAttached_bit() {
        return this.attached_bit;
    }

    public void setAttached_bit(boolean attached_bit) {
        this.attached_bit = attached_bit;
    }

    public boolean isExternal_bit() {
        return this.external_bit;
    }

    public void setExternal_bit(boolean external_bit) {
        this.external_bit = external_bit;
    }

    public boolean isAbr_bit() {
        return this.abr_bit;
    }

    public void setAbr_bit(boolean abr_bit) {
        this.abr_bit = abr_bit;
    }

    public String toString() {
        return "NODE FLAGS [OB=" + this.isOverload_bit() + "AB=" + this.isAttached_bit() + "EB=" + this.isAttached_bit() + "AB=" + this.isAbr_bit() + "]";
    }
}

