/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class MaxReservableBandwidthLinkAttribTLV
extends BGP4TLVFormat {
    public float maximumReservableBandwidth;

    public MaxReservableBandwidthLinkAttribTLV() {
        this.setTLVType(1090);
    }

    public MaxReservableBandwidthLinkAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int bwi = Float.floatToIntBits(this.maximumReservableBandwidth);
        this.tlv_bytes[4] = (byte)(bwi >>> 24);
        this.tlv_bytes[5] = (byte)(bwi >> 16 & 0xFF);
        this.tlv_bytes[6] = (byte)(bwi >> 8 & 0xFF);
        this.tlv_bytes[7] = (byte)(bwi & 0xFF);
    }

    protected void decode() {
        if (this.getTLVValueLength() != 4) {
            // empty if block
        }
        int bwi = 0;
        for (int k = 0; k < 4; ++k) {
            bwi = bwi << 8 | this.tlv_bytes[k + 4] & 0xFF;
        }
        this.maximumReservableBandwidth = Float.intBitsToFloat(bwi);
    }

    public void setMaximumReservableBandwidth(float maximumReservableBandwidth) {
        this.maximumReservableBandwidth = maximumReservableBandwidth;
    }

    public float getMaximumReservableBandwidth() {
        return this.maximumReservableBandwidth;
    }

    public String toString() {
        return " MAXIMUM BW [ Bandwidth = " + Float.toString(this.maximumReservableBandwidth) + "]";
    }
}

