/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class IS_IS_AreaIdentifierNodeAttribTLV
extends BGP4TLVFormat {
    private LinkedList<Inet4Address> ipv4areaIDs;

    public IS_IS_AreaIdentifierNodeAttribTLV() {
        this.setTLVType(1027);
        this.ipv4areaIDs = new LinkedList();
    }

    public IS_IS_AreaIdentifierNodeAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.ipv4areaIDs.size() * 4);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int i = 0;
        int offset = 4;
        for (i = 0; i < this.ipv4areaIDs.size(); ++i) {
            System.arraycopy(this.ipv4areaIDs.get(i).getAddress(), 0, this.tlv_bytes, offset, 4);
            offset += 4;
        }
    }

    public void decode() {
        this.ipv4areaIDs = new LinkedList();
        int number_addresses = this.getTLVValueLength() / 4;
        int offset = 4;
        byte[] address = new byte[4];
        Inet4Address idarea = null;
        for (int i = 0; i < number_addresses; ++i) {
            System.arraycopy(this.tlv_bytes, offset, address, 0, 4);
            try {
                idarea = (Inet4Address)Inet4Address.getByAddress(address);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            this.ipv4areaIDs.add(idarea);
            offset += 4;
        }
    }

    public LinkedList<Inet4Address> getIpv4areaIDs() {
        return this.ipv4areaIDs;
    }

    public void setIpv4areaIDs(LinkedList<Inet4Address> ipv4areaIDs) {
        this.ipv4areaIDs = ipv4areaIDs;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this.ipv4areaIDs.size(); ++i) {
            ret = "ISIS AREA [" + i + "] IDENTIFIER: " + this.ipv4areaIDs.get(i).toString();
        }
        return ret;
    }
}

