/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;

public class IGPFlagBitsPrefixAttribTLV
extends BGP4TLVFormat {
    private boolean up_dw_bit = false;
    private byte flags;

    public IGPFlagBitsPrefixAttribTLV() {
        this.setTLVType(1152);
        this.setTLVValueLength(1);
    }

    public IGPFlagBitsPrefixAttribTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        if (this.isUp_dw_bit()) {
            int n = offset;
            this.tlv_bytes[n] = (byte)(this.tlv_bytes[n] | 0xFFFFFF80);
        }
    }

    public void decode() {
        int offset = 4;
        this.flags = this.tlv_bytes[offset];
        if ((this.flags & 0x80) == 128) {
            this.setUp_dw_bit(true);
        }
    }

    public boolean isUp_dw_bit() {
        return this.up_dw_bit;
    }

    public void setUp_dw_bit(boolean up_dw_bit) {
        this.up_dw_bit = up_dw_bit;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public String toString() {
        return "IGP FLAGS [D=" + this.isUp_dw_bit() + "]";
    }
}

