/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields.pathAttributes;

import es.tid.bgp.bgp4.update.fields.PathAttribute;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class MP_Reach_Attribute
extends PathAttribute {
    private int addressFamilyIdentifier;
    private int subsequentAddressFamilyIdentifier;
    private InetAddress nextHop;
    private int nextHopLength;

    public MP_Reach_Attribute() {
        this.setTypeCode(14);
        this.optionalBit = true;
        this.transitiveBit = false;
        this.nextHopLength = 4;
        try {
            this.nextHop = Inet4Address.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public MP_Reach_Attribute(byte[] bytes, int offset) {
        super(bytes, offset);
        int offset2 = this.mandatoryLength;
        this.addressFamilyIdentifier = (this.bytes[offset2] & 0xFF) << 8 | this.bytes[offset2 + 1] & 0xFF;
        this.subsequentAddressFamilyIdentifier = this.bytes[offset2 + 2] & 0xFF;
        this.nextHopLength = this.bytes[offset2 + 3] & 0xFF;
        byte[] bytos = new byte[this.nextHopLength];
        System.arraycopy(bytes, offset2 + 4, bytos, 0, this.nextHopLength);
        if (this.nextHopLength == 4) {
            try {
                this.nextHop = Inet4Address.getByAddress(bytos);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }

    protected void encodeMP_Reach_Header() {
        int offset = this.getMandatoryLength();
        this.bytes[offset] = (byte)(this.addressFamilyIdentifier >> 8 & 0xFF);
        this.bytes[offset + 1] = (byte)(this.addressFamilyIdentifier & 0xFF);
        this.bytes[offset + 2] = (byte)(this.subsequentAddressFamilyIdentifier & 0xFF);
        this.bytes[offset + 3] = (byte)this.getNextHopLength();
        offset += 4;
        if (this.nextHopLength == 4) {
            System.arraycopy(this.nextHop.getAddress(), 0, this.bytes, offset, 4);
        }
        this.bytes[offset += this.getNextHopLength()] = 0;
    }

    public int getLengthofNextHopNetworkAddress() {
        return this.nextHopLength;
    }

    public int getAddressFamilyIdentifier() {
        return this.addressFamilyIdentifier;
    }

    protected void setAddressFamilyIdentifier(int addressFamilyIdentifier) {
        this.addressFamilyIdentifier = addressFamilyIdentifier;
    }

    public int getSubsequentAddressFamilyIdentifier() {
        return this.subsequentAddressFamilyIdentifier;
    }

    protected void setSubsequentAddressFamilyIdentifier(int subsequentAddressFamilyIdentifier) {
        this.subsequentAddressFamilyIdentifier = subsequentAddressFamilyIdentifier;
    }

    public static int getAFI(byte[] bytes, int offset) {
        int ml = PathAttribute.getMandatoryLength(bytes, offset);
        int offset2 = offset + ml;
        int addressFamilyIdentifier = (bytes[offset2] & 0xFF) << 8 | bytes[offset2 + 1] & 0xFF;
        return addressFamilyIdentifier;
    }

    public static int getSAFI(byte[] bytes, int offset) {
        int ml = PathAttribute.getMandatoryLength(bytes, offset);
        int offset2 = offset + ml;
        int subsequentAddressFamilyIdentifier = bytes[offset2 + 2] & 0xFF;
        return subsequentAddressFamilyIdentifier;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(InetAddress nextHop) {
        this.nextHop = nextHop;
        this.nextHopLength = nextHop instanceof Inet4Address ? 4 : (nextHop instanceof Inet6Address ? 8 : 4);
    }

    public int getNextHopLength() {
        return this.nextHopLength;
    }

    public void setNextHopLength(int nextHopLength) {
        this.nextHopLength = nextHopLength;
    }

    public String toString() {
        return "mp";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.addressFamilyIdentifier;
        result = 31 * result + (this.nextHop == null ? 0 : this.nextHop.hashCode());
        result = 31 * result + this.nextHopLength;
        result = 31 * result + this.subsequentAddressFamilyIdentifier;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MP_Reach_Attribute other = (MP_Reach_Attribute)obj;
        if (this.addressFamilyIdentifier != other.addressFamilyIdentifier) {
            return false;
        }
        if (this.nextHop == null ? other.nextHop != null : !this.nextHop.equals(other.nextHop)) {
            return false;
        }
        if (this.nextHopLength != other.nextHopLength) {
            return false;
        }
        return this.subsequentAddressFamilyIdentifier == other.subsequentAddressFamilyIdentifier;
    }
}

