/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields.pathAttributes;

import es.tid.bgp.bgp4.BGP4Element;
import es.tid.bgp.bgp4.update.MalformedBGP4ElementException;
import java.util.Arrays;

public class AS_Path_Segment
implements BGP4Element {
    private int type;
    private int numberOfSegments;
    private long[] segments;
    private byte[] bytes;
    private int length;
    private boolean AS4 = true;

    public void setAS4(boolean as4) {
        this.AS4 = as4;
    }

    public AS_Path_Segment() {
        this.type = 2;
    }

    public AS_Path_Segment(byte[] bytes, int offset) throws MalformedBGP4ElementException {
        this.type = bytes[offset] & 0xFF;
        this.numberOfSegments = bytes[offset + 1] & 0xFF;
        this.length = 2 + this.numberOfSegments * 4;
        if (bytes.length - offset < this.length) {
            this.length = 2 + this.numberOfSegments * 2;
            this.AS4 = false;
        } else {
            this.AS4 = true;
        }
        this.segments = new long[this.numberOfSegments];
        if (this.type != 2 && this.type != 1) {
            throw new MalformedBGP4ElementException();
        }
        for (int i = 0; i < this.numberOfSegments; ++i) {
            this.segments[i] = !this.AS4 ? (long)((bytes[offset + 2 + i * 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 2 + i * 2 + 1] & 0xFF) : (long)((bytes[offset + 2 + i * 4] & 0xFF) << 24 & 0xFF000000 | (bytes[offset + 2 + i * 4 + 1] & 0xFF0000) << 16 & 0xFF00 | (bytes[offset + 2 + i * 4 + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 2 + i * 4 + 3] & 0xFF);
        }
    }

    @Override
    public void encode() {
        if (this.AS4) {
            this.length = 2 + this.numberOfSegments * 4;
        }
        if (!this.AS4) {
            this.length = 2 + this.numberOfSegments * 2;
        }
        int offset = 0;
        this.bytes = new byte[this.length];
        this.bytes[offset++] = (byte)(this.type & 0xFF);
        this.bytes[offset++] = (byte)(this.numberOfSegments & 0xFF);
        for (int i = 0; i < this.numberOfSegments; ++i) {
            if (this.AS4) {
                this.bytes[offset++] = (byte)(this.segments[i] & 0xFFFFFFFFFFFFFFFFL & 0xFFL);
                this.bytes[offset++] = (byte)(this.segments[i] & 0xFFL & 0xFFL);
                this.bytes[offset++] = (byte)(this.segments[i] & 0xFFL & 0xFFL);
                this.bytes[offset++] = (byte)(this.segments[i] & 0xFFL);
                continue;
            }
            this.bytes[offset++] = (byte)(this.segments[i] & 0xFFL & 0xFFL);
            this.bytes[offset++] = (byte)(this.segments[i] & 0xFFL);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            this.encode();
        }
        return this.bytes;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getNumberOfSegments() {
        return this.numberOfSegments;
    }

    public int[] getSegments() {
        int[] temp_segments = new int[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            temp_segments[i] = (int)this.segments[i];
        }
        return temp_segments;
    }

    public long[] get4Segments() {
        return this.segments;
    }

    public void set4Segments(long[] segments) {
        if (segments == null) {
            this.segments = new long[0];
        } else {
            this.segments = segments;
            this.numberOfSegments = this.segments.length;
        }
    }

    public void setSegments(int[] segments) {
        if (segments == null) {
            this.segments = new long[0];
        } else {
            this.segments = new long[segments.length];
            for (int i = 0; i < segments.length; ++i) {
                this.segments[i] = segments[i];
            }
            this.numberOfSegments = this.segments.length;
        }
    }

    public String toString() {
        return "AS_PATH_SEGMENT [Type=" + this.type + " NumberOfSegments=" + this.numberOfSegments + " Total Length=" + this.length + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AS_Path_Segment other = (AS_Path_Segment)obj;
        if (!Arrays.equals(this.bytes, other.getBytes())) {
            return false;
        }
        return this.length == other.getLength();
    }
}

