/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;
import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.bgp.bgp4.update.tlv.LocalNodeDescriptorsTLV;
import es.tid.bgp.bgp4.update.tlv.RemoteNodeDescriptorsTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IPv4InterfaceAddressLinkDescriptorsSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IPv4NeighborAddressLinkDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.LinkLocalRemoteIdentifiersLinkDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.MinMaxUndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalAvailableBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalDelayVariationDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkDelayDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalLinkLossDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalResidualBandwidthDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.UndirectionalUtilizedBandwidthDescriptorSubTLV;

public class LinkNLRI
extends LinkStateNLRI {
    private int protocolID;
    private long identifier;
    private LocalNodeDescriptorsTLV localNodeDescriptors;
    private RemoteNodeDescriptorsTLV remoteNodeDescriptorsTLV;
    private LinkLocalRemoteIdentifiersLinkDescriptorSubTLV linkIdentifiersTLV;
    private IPv4InterfaceAddressLinkDescriptorsSubTLV ipv4InterfaceAddressTLV;
    private IPv4NeighborAddressLinkDescriptorSubTLV ipv4NeighborAddressTLV;
    private UndirectionalLinkDelayDescriptorSubTLV undirectionalLinkDelayTLV;
    private MinMaxUndirectionalLinkDelayDescriptorSubTLV minMaxUndirectionalLinkDelayTLV;
    private UndirectionalDelayVariationDescriptorSubTLV undirectionalDelayVariationTLV;
    private UndirectionalLinkLossDescriptorSubTLV undirectionalLinkLossTLV;
    private UndirectionalResidualBandwidthDescriptorSubTLV undirectionalResidualBwTLV;
    private UndirectionalAvailableBandwidthDescriptorSubTLV undirectionalAvailableBwTLV;
    private UndirectionalUtilizedBandwidthDescriptorSubTLV undirectionalUtilizedBwTLV;

    public LinkNLRI() {
        this.setIdentifier(0L);
        this.setNLRIType(2);
    }

    public LinkNLRI(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 13;
        if (this.localNodeDescriptors != null) {
            this.localNodeDescriptors.encode();
            len += this.localNodeDescriptors.getTotalTLVLength();
        }
        if (this.remoteNodeDescriptorsTLV != null) {
            this.remoteNodeDescriptorsTLV.encode();
            len += this.remoteNodeDescriptorsTLV.getTotalTLVLength();
        }
        if (this.linkIdentifiersTLV != null) {
            this.linkIdentifiersTLV.encode();
            len += this.linkIdentifiersTLV.getTotalTLVLength();
        }
        if (this.ipv4InterfaceAddressTLV != null) {
            this.ipv4InterfaceAddressTLV.encode();
            len += this.ipv4InterfaceAddressTLV.getTotalTLVLength();
        }
        if (this.ipv4NeighborAddressTLV != null) {
            this.ipv4NeighborAddressTLV.encode();
            len += this.ipv4NeighborAddressTLV.getTotalTLVLength();
        }
        if (this.undirectionalLinkDelayTLV != null) {
            this.undirectionalLinkDelayTLV.encode();
            len += this.undirectionalLinkDelayTLV.getTotalTLVLength();
        }
        if (this.minMaxUndirectionalLinkDelayTLV != null) {
            this.minMaxUndirectionalLinkDelayTLV.encode();
            len += this.minMaxUndirectionalLinkDelayTLV.getTotalTLVLength();
        }
        if (this.undirectionalDelayVariationTLV != null) {
            this.undirectionalDelayVariationTLV.encode();
            len += this.undirectionalDelayVariationTLV.getTotalTLVLength();
        }
        if (this.undirectionalLinkLossTLV != null) {
            this.undirectionalLinkLossTLV.encode();
            len += this.undirectionalLinkLossTLV.getTotalTLVLength();
        }
        if (this.undirectionalResidualBwTLV != null) {
            this.undirectionalResidualBwTLV.encode();
            len += this.undirectionalResidualBwTLV.getTotalTLVLength();
        }
        if (this.undirectionalAvailableBwTLV != null) {
            this.undirectionalAvailableBwTLV.encode();
            len += this.undirectionalAvailableBwTLV.getTotalTLVLength();
        }
        if (this.undirectionalUtilizedBwTLV != null) {
            this.undirectionalUtilizedBwTLV.encode();
            len += this.undirectionalUtilizedBwTLV.getTotalTLVLength();
        }
        this.setTotalNLRILength(len);
        this.setLength(len);
        this.bytes = new byte[len];
        this.encodeHeader();
        this.bytes[4] = (byte)this.protocolID;
        this.bytes[5] = (byte)(this.identifier >>> 56 & 0xFFL);
        this.bytes[6] = (byte)(this.identifier >>> 48 & 0xFFL);
        this.bytes[7] = (byte)(this.identifier >>> 40 & 0xFFL);
        this.bytes[8] = (byte)(this.identifier >>> 32 & 0xFFL);
        this.bytes[9] = (byte)(this.identifier >>> 24 & 0xFFL);
        this.bytes[10] = (byte)(this.identifier >>> 16 & 0xFFL);
        this.bytes[11] = (byte)(this.identifier >>> 8 & 0xFFL);
        this.bytes[12] = (byte)(this.identifier & 0xFFL);
        int offset = 13;
        if (this.localNodeDescriptors != null) {
            System.arraycopy(this.localNodeDescriptors.getTlv_bytes(), 0, this.bytes, offset, this.localNodeDescriptors.getTotalTLVLength());
            offset += this.localNodeDescriptors.getTotalTLVLength();
        }
        if (this.remoteNodeDescriptorsTLV != null) {
            System.arraycopy(this.remoteNodeDescriptorsTLV.getTlv_bytes(), 0, this.bytes, offset, this.remoteNodeDescriptorsTLV.getTotalTLVLength());
            offset += this.remoteNodeDescriptorsTLV.getTotalTLVLength();
        }
        if (this.linkIdentifiersTLV != null) {
            try {
                System.arraycopy(this.linkIdentifiersTLV.getTlv_bytes(), 0, this.bytes, offset, this.linkIdentifiersTLV.getTotalTLVLength());
                offset += this.linkIdentifiersTLV.getTotalTLVLength();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.ipv4InterfaceAddressTLV != null) {
            System.arraycopy(this.ipv4InterfaceAddressTLV.getTlv_bytes(), 0, this.bytes, offset, this.ipv4InterfaceAddressTLV.getTotalTLVLength());
            offset += this.ipv4InterfaceAddressTLV.getTotalTLVLength();
        }
        if (this.ipv4NeighborAddressTLV != null) {
            System.arraycopy(this.ipv4NeighborAddressTLV.getTlv_bytes(), 0, this.bytes, offset, this.ipv4NeighborAddressTLV.getTotalTLVLength());
            offset += this.ipv4NeighborAddressTLV.getTotalTLVLength();
        }
        if (this.undirectionalLinkDelayTLV != null) {
            System.arraycopy(this.undirectionalLinkDelayTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalLinkDelayTLV.getTotalTLVLength());
            offset += this.undirectionalLinkDelayTLV.getTotalTLVLength();
        }
        if (this.minMaxUndirectionalLinkDelayTLV != null) {
            System.arraycopy(this.minMaxUndirectionalLinkDelayTLV.getTlv_bytes(), 0, this.bytes, offset, this.minMaxUndirectionalLinkDelayTLV.getTotalTLVLength());
            offset += this.minMaxUndirectionalLinkDelayTLV.getTotalTLVLength();
        }
        if (this.undirectionalDelayVariationTLV != null) {
            System.arraycopy(this.undirectionalDelayVariationTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalDelayVariationTLV.getTotalTLVLength());
            offset += this.undirectionalDelayVariationTLV.getTotalTLVLength();
        }
        if (this.undirectionalLinkLossTLV != null) {
            System.arraycopy(this.undirectionalLinkLossTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalLinkLossTLV.getTotalTLVLength());
            offset += this.undirectionalLinkLossTLV.getTotalTLVLength();
        }
        if (this.undirectionalResidualBwTLV != null) {
            System.arraycopy(this.undirectionalResidualBwTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalResidualBwTLV.getTotalTLVLength());
            offset += this.undirectionalResidualBwTLV.getTotalTLVLength();
        }
        if (this.undirectionalAvailableBwTLV != null) {
            System.arraycopy(this.undirectionalAvailableBwTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalAvailableBwTLV.getTotalTLVLength());
            offset += this.undirectionalAvailableBwTLV.getTotalTLVLength();
        }
        if (this.undirectionalUtilizedBwTLV != null) {
            System.arraycopy(this.undirectionalUtilizedBwTLV.getTlv_bytes(), 0, this.bytes, offset, this.undirectionalUtilizedBwTLV.getTotalTLVLength());
            offset += this.undirectionalUtilizedBwTLV.getTotalTLVLength();
        }
    }

    public void decode() {
        int offset = 4;
        this.protocolID = this.bytes[offset];
        byte[] ip = new byte[8];
        System.arraycopy(this.bytes, ++offset, ip, 0, 8);
        long routingUniverseIdentifieraux1 = ((long)this.bytes[offset] & 0xFFL) << 24 & 0xFFFFFFFFFF000000L | (long)this.bytes[offset + 1] << 16 & 0xFF0000L | (long)this.bytes[offset + 2] << 8 & 0xFF00L | (long)this.bytes[offset + 3] & 0xFFL;
        long routingUniverseIdentifieraux2 = ((long)this.bytes[offset + 4] & 0xFFL) << 24 & 0xFFFFFFFFFF000000L | (long)this.bytes[offset + 5] << 16 & 0xFF0000L | (long)this.bytes[offset + 6] << 8 & 0xFF00L | (long)this.bytes[offset + 7] & 0xFFL;
        this.setIdentifier(routingUniverseIdentifieraux1 << 32 & 0xFFFFFFFF00000000L | routingUniverseIdentifieraux2);
        this.localNodeDescriptors = new LocalNodeDescriptorsTLV(this.bytes, offset += 8);
        this.remoteNodeDescriptorsTLV = new RemoteNodeDescriptorsTLV(this.bytes, offset += this.localNodeDescriptors.getTotalTLVLength());
        boolean fin = false;
        if ((offset += this.remoteNodeDescriptorsTLV.getTotalTLVLength()) >= this.getTotalNLRILength()) {
            fin = true;
        }
        while (!fin) {
            int subTLVType = BGP4TLVFormat.getType(this.bytes, offset);
            int subTLVLength = BGP4TLVFormat.getTotalTLVLength(this.bytes, offset);
            switch (subTLVType) {
                case 258: {
                    this.linkIdentifiersTLV = new LinkLocalRemoteIdentifiersLinkDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 259: {
                    this.ipv4InterfaceAddressTLV = new IPv4InterfaceAddressLinkDescriptorsSubTLV(this.bytes, offset);
                    break;
                }
                case 260: {
                    this.ipv4NeighborAddressTLV = new IPv4NeighborAddressLinkDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1104: {
                    this.undirectionalLinkDelayTLV = new UndirectionalLinkDelayDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1105: {
                    this.minMaxUndirectionalLinkDelayTLV = new MinMaxUndirectionalLinkDelayDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1106: {
                    this.undirectionalDelayVariationTLV = new UndirectionalDelayVariationDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1107: {
                    this.undirectionalLinkLossTLV = new UndirectionalLinkLossDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1108: {
                    this.undirectionalResidualBwTLV = new UndirectionalResidualBandwidthDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1109: {
                    this.undirectionalAvailableBwTLV = new UndirectionalAvailableBandwidthDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                case 1110: {
                    this.undirectionalUtilizedBwTLV = new UndirectionalUtilizedBandwidthDescriptorSubTLV(this.bytes, offset);
                    break;
                }
                default: {
                    log.warn("Unknown TLV found, type :" + subTLVType);
                }
            }
            if ((offset += subTLVLength) < this.getTotalNLRILength()) continue;
            fin = true;
        }
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long identifier) {
        this.identifier = identifier;
    }

    public LocalNodeDescriptorsTLV getLocalNodeDescriptors() {
        return this.localNodeDescriptors;
    }

    public void setLocalNodeDescriptors(LocalNodeDescriptorsTLV localNodeDescriptors) {
        this.localNodeDescriptors = localNodeDescriptors;
    }

    public RemoteNodeDescriptorsTLV getRemoteNodeDescriptorsTLV() {
        return this.remoteNodeDescriptorsTLV;
    }

    public void setRemoteNodeDescriptorsTLV(RemoteNodeDescriptorsTLV remoteNodeDescriptorsTLV) {
        this.remoteNodeDescriptorsTLV = remoteNodeDescriptorsTLV;
    }

    public LinkLocalRemoteIdentifiersLinkDescriptorSubTLV getLinkIdentifiersTLV() {
        return this.linkIdentifiersTLV;
    }

    public void setLinkIdentifiersTLV(LinkLocalRemoteIdentifiersLinkDescriptorSubTLV linkIdentifiersTLV) {
        this.linkIdentifiersTLV = linkIdentifiersTLV;
    }

    public IPv4InterfaceAddressLinkDescriptorsSubTLV getIpv4InterfaceAddressTLV() {
        return this.ipv4InterfaceAddressTLV;
    }

    public void setIpv4InterfaceAddressTLV(IPv4InterfaceAddressLinkDescriptorsSubTLV ipv4InterfaceAddressTLV) {
        this.ipv4InterfaceAddressTLV = ipv4InterfaceAddressTLV;
    }

    public IPv4NeighborAddressLinkDescriptorSubTLV getIpv4NeighborAddressTLV() {
        return this.ipv4NeighborAddressTLV;
    }

    public void setIpv4NeighborAddressTLV(IPv4NeighborAddressLinkDescriptorSubTLV ipv4NeighborAddressTLV) {
        this.ipv4NeighborAddressTLV = ipv4NeighborAddressTLV;
    }

    public UndirectionalLinkDelayDescriptorSubTLV getUndirectionalLinkDelayTLV() {
        return this.undirectionalLinkDelayTLV;
    }

    public void setUndirectionalLinkDelayTLV(UndirectionalLinkDelayDescriptorSubTLV undirectionalLinkDelayTLV) {
        this.undirectionalLinkDelayTLV = undirectionalLinkDelayTLV;
    }

    public MinMaxUndirectionalLinkDelayDescriptorSubTLV getMinMaxUndirectionalLinkDelayTLV() {
        return this.minMaxUndirectionalLinkDelayTLV;
    }

    public void setMinMaxUndirectionalLinkDelayTLV(MinMaxUndirectionalLinkDelayDescriptorSubTLV minMaxUndirectionalLinkDelayTLV) {
        this.minMaxUndirectionalLinkDelayTLV = minMaxUndirectionalLinkDelayTLV;
    }

    public UndirectionalDelayVariationDescriptorSubTLV getUndirectionalDelayVariationTLV() {
        return this.undirectionalDelayVariationTLV;
    }

    public void setUndirectionalDelayVariationTLV(UndirectionalDelayVariationDescriptorSubTLV undirectionalDelayVariationTLV) {
        this.undirectionalDelayVariationTLV = undirectionalDelayVariationTLV;
    }

    public UndirectionalLinkLossDescriptorSubTLV getUndirectionalLinkLossTLV() {
        return this.undirectionalLinkLossTLV;
    }

    public void setUndirectionalLinkLossTLV(UndirectionalLinkLossDescriptorSubTLV undirectionalPackectLossTLV) {
        this.undirectionalLinkLossTLV = undirectionalPackectLossTLV;
    }

    public UndirectionalResidualBandwidthDescriptorSubTLV getUndirectionalResidualBwTLV() {
        return this.undirectionalResidualBwTLV;
    }

    public void setUndirectionalResidualBwTLV(UndirectionalResidualBandwidthDescriptorSubTLV undirectionalResidualBwTLV) {
        this.undirectionalResidualBwTLV = undirectionalResidualBwTLV;
    }

    public UndirectionalAvailableBandwidthDescriptorSubTLV getUndirectionalAvailableBwTLV() {
        return this.undirectionalAvailableBwTLV;
    }

    public void setUndirectionalAvailableBwTLV(UndirectionalAvailableBandwidthDescriptorSubTLV undirectionalAvailableBwTLV) {
        this.undirectionalAvailableBwTLV = undirectionalAvailableBwTLV;
    }

    public UndirectionalUtilizedBandwidthDescriptorSubTLV getUndirectionalUtilizedBwTLV() {
        return this.undirectionalUtilizedBwTLV;
    }

    public void setUndirectionalUtilizedBwTLV(UndirectionalUtilizedBandwidthDescriptorSubTLV undirectionalUtilizedBwTLV) {
        this.undirectionalUtilizedBwTLV = undirectionalUtilizedBwTLV;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("Link NLRI:");
        if (this.localNodeDescriptors != null) {
            sb.append("\n> Local Node Descriptors: ");
            sb.append(this.localNodeDescriptors.toString());
        }
        if (this.remoteNodeDescriptorsTLV != null) {
            sb.append(" ");
            sb.append("> Remote Node Descriptors: ");
            sb.append(this.remoteNodeDescriptorsTLV.toString());
        }
        sb.append("\n> Link Descriptors: ");
        if (this.linkIdentifiersTLV != null) {
            sb.append(" ");
            sb.append("\n\t> " + this.linkIdentifiersTLV.toString());
        }
        if (this.ipv4InterfaceAddressTLV != null) {
            sb.append(" ");
            sb.append("> Ipv4 Interface Address TLV: ");
            sb.append("\n\t> " + this.ipv4InterfaceAddressTLV.toString());
        }
        if (this.ipv4NeighborAddressTLV != null) {
            sb.append(" ");
            sb.append("> Ipv4 Neighbor Address TLV: ");
            sb.append("\n\t> " + this.ipv4NeighborAddressTLV.toString());
        }
        if (this.undirectionalLinkDelayTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Link Delay TLV:");
            sb.append("\n\t> " + this.undirectionalLinkDelayTLV.toString());
        }
        if (this.minMaxUndirectionalLinkDelayTLV != null) {
            sb.append(" ");
            sb.append("> Min/Max Undirectional Link Delay TLV:");
            sb.append("\n\t> " + this.minMaxUndirectionalLinkDelayTLV.toString());
        }
        if (this.undirectionalDelayVariationTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Delay Variation TLV:");
            sb.append("\n\t> " + this.undirectionalDelayVariationTLV.toString());
        }
        if (this.undirectionalLinkLossTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Link Loss TLV:");
            sb.append("\n\t> " + this.undirectionalLinkLossTLV.toString());
        }
        if (this.undirectionalResidualBwTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Residual Bandwidth TLV:");
            sb.append("\n\t> " + this.undirectionalResidualBwTLV.toString());
        }
        if (this.undirectionalAvailableBwTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Available Bandwidth TLV:");
            sb.append("\n\t> " + this.undirectionalAvailableBwTLV.toString());
        }
        if (this.undirectionalUtilizedBwTLV != null) {
            sb.append(" ");
            sb.append("> Undirectional Utilized Bandwidth TLV:");
            sb.append("\n\t> " + this.undirectionalUtilizedBwTLV.toString());
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.identifier ^ this.identifier >>> 32);
        result = 31 * result + (this.ipv4InterfaceAddressTLV == null ? 0 : this.ipv4InterfaceAddressTLV.hashCode());
        result = 31 * result + (this.ipv4NeighborAddressTLV == null ? 0 : this.ipv4NeighborAddressTLV.hashCode());
        result = 31 * result + (this.linkIdentifiersTLV == null ? 0 : this.linkIdentifiersTLV.hashCode());
        result = 31 * result + (this.localNodeDescriptors == null ? 0 : this.localNodeDescriptors.hashCode());
        result = 31 * result + (this.minMaxUndirectionalLinkDelayTLV == null ? 0 : this.minMaxUndirectionalLinkDelayTLV.hashCode());
        result = 31 * result + this.protocolID;
        result = 31 * result + (this.remoteNodeDescriptorsTLV == null ? 0 : this.remoteNodeDescriptorsTLV.hashCode());
        result = 31 * result + (this.undirectionalAvailableBwTLV == null ? 0 : this.undirectionalAvailableBwTLV.hashCode());
        result = 31 * result + (this.undirectionalDelayVariationTLV == null ? 0 : this.undirectionalDelayVariationTLV.hashCode());
        result = 31 * result + (this.undirectionalLinkDelayTLV == null ? 0 : this.undirectionalLinkDelayTLV.hashCode());
        result = 31 * result + (this.undirectionalLinkLossTLV == null ? 0 : this.undirectionalLinkLossTLV.hashCode());
        result = 31 * result + (this.undirectionalResidualBwTLV == null ? 0 : this.undirectionalResidualBwTLV.hashCode());
        result = 31 * result + (this.undirectionalUtilizedBwTLV == null ? 0 : this.undirectionalUtilizedBwTLV.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkNLRI other = (LinkNLRI)obj;
        if (this.identifier != other.identifier) {
            return false;
        }
        if (this.ipv4InterfaceAddressTLV == null ? other.ipv4InterfaceAddressTLV != null : !this.ipv4InterfaceAddressTLV.equals(other.ipv4InterfaceAddressTLV)) {
            return false;
        }
        if (this.ipv4NeighborAddressTLV == null ? other.ipv4NeighborAddressTLV != null : !this.ipv4NeighborAddressTLV.equals(other.ipv4NeighborAddressTLV)) {
            return false;
        }
        if (this.linkIdentifiersTLV == null ? other.linkIdentifiersTLV != null : !this.linkIdentifiersTLV.equals(other.linkIdentifiersTLV)) {
            return false;
        }
        if (this.localNodeDescriptors == null ? other.localNodeDescriptors != null : !this.localNodeDescriptors.equals(other.localNodeDescriptors)) {
            return false;
        }
        if (this.minMaxUndirectionalLinkDelayTLV == null ? other.minMaxUndirectionalLinkDelayTLV != null : !this.minMaxUndirectionalLinkDelayTLV.equals(other.minMaxUndirectionalLinkDelayTLV)) {
            return false;
        }
        if (this.protocolID != other.protocolID) {
            return false;
        }
        if (this.remoteNodeDescriptorsTLV == null ? other.remoteNodeDescriptorsTLV != null : !this.remoteNodeDescriptorsTLV.equals(other.remoteNodeDescriptorsTLV)) {
            return false;
        }
        if (this.undirectionalAvailableBwTLV == null ? other.undirectionalAvailableBwTLV != null : !this.undirectionalAvailableBwTLV.equals(other.undirectionalAvailableBwTLV)) {
            return false;
        }
        if (this.undirectionalDelayVariationTLV == null ? other.undirectionalDelayVariationTLV != null : !this.undirectionalDelayVariationTLV.equals(other.undirectionalDelayVariationTLV)) {
            return false;
        }
        if (this.undirectionalLinkDelayTLV == null ? other.undirectionalLinkDelayTLV != null : !this.undirectionalLinkDelayTLV.equals(other.undirectionalLinkDelayTLV)) {
            return false;
        }
        if (this.undirectionalLinkLossTLV == null ? other.undirectionalLinkLossTLV != null : !this.undirectionalLinkLossTLV.equals(other.undirectionalLinkLossTLV)) {
            return false;
        }
        if (this.undirectionalResidualBwTLV == null ? other.undirectionalResidualBwTLV != null : !this.undirectionalResidualBwTLV.equals(other.undirectionalResidualBwTLV)) {
            return false;
        }
        return !(this.undirectionalUtilizedBwTLV == null ? other.undirectionalUtilizedBwTLV != null : !this.undirectionalUtilizedBwTLV.equals(other.undirectionalUtilizedBwTLV));
    }
}

