/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;

public class ITNodeNLRI
extends LinkStateNLRI {
    private String nodeId;
    private String controllerIT;
    private String cpu;
    private String mem;
    private String storage;

    public ITNodeNLRI() {
        this.setNLRIType(5);
    }

    public ITNodeNLRI(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int i;
        int len = 4;
        byte[] bytesStringNodeId = this.nodeId.getBytes();
        len = len + 4 + bytesStringNodeId.length;
        byte[] bytesStringControllerIT = this.controllerIT.getBytes();
        len = len + 4 + bytesStringControllerIT.length;
        byte[] bytesStringCpu = this.cpu.getBytes();
        len += 4 + bytesStringCpu.length;
        byte[] bytesStringMem = this.mem.getBytes();
        len += 4 + bytesStringMem.length;
        byte[] bytesStringStorage = this.storage.getBytes();
        this.setTotalNLRILength(len += 4 + bytesStringStorage.length);
        this.setLength(len);
        this.bytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        offset = this.encodeHeaderSubTLV(1, bytesStringNodeId.length, offset);
        for (i = 0; i < bytesStringNodeId.length; ++i) {
            this.bytes[offset] = bytesStringNodeId[i];
            ++offset;
        }
        offset = this.encodeHeaderSubTLV(2, bytesStringControllerIT.length, offset);
        for (i = 0; i < bytesStringControllerIT.length; ++i) {
            this.bytes[offset] = bytesStringControllerIT[i];
            ++offset;
        }
        offset = this.encodeHeaderSubTLV(3, bytesStringCpu.length, offset);
        for (i = 0; i < bytesStringCpu.length; ++i) {
            this.bytes[offset] = bytesStringCpu[i];
            ++offset;
        }
        offset = this.encodeHeaderSubTLV(4, bytesStringMem.length, offset);
        for (i = 0; i < bytesStringMem.length; ++i) {
            this.bytes[offset] = bytesStringMem[i];
            ++offset;
        }
        offset = this.encodeHeaderSubTLV(5, bytesStringStorage.length, offset);
        for (i = 0; i < bytesStringStorage.length; ++i) {
            this.bytes[offset] = bytesStringStorage[i];
            ++offset;
        }
    }

    public void decode() {
        int lengthResource;
        int offset = 2;
        byte[] lengthITNodeNLRIBytes = new byte[2];
        System.arraycopy(this.bytes, offset, lengthITNodeNLRIBytes, 0, 2);
        int lengthITNodeNLRI = lengthITNodeNLRIBytes[0] << 8 & 0xFF00 | lengthITNodeNLRIBytes[1] & 0xFF;
        offset += 2;
        block7: for (int lengthResourcesgeted = 0; lengthResourcesgeted < lengthITNodeNLRI; lengthResourcesgeted += 4 + lengthResource) {
            byte[] typeResourceBytes = new byte[2];
            System.arraycopy(this.bytes, offset, typeResourceBytes, 0, 2);
            int typeResource = typeResourceBytes[0] << 8 & 0xFF00 | typeResourceBytes[1] & 0xFF;
            byte[] lengthResourceBytes = new byte[2];
            System.arraycopy(this.bytes, offset += 2, lengthResourceBytes, 0, 2);
            lengthResource = lengthResourceBytes[0] << 8 & 0xFF00 | lengthResourceBytes[1] & 0xFF;
            byte[] valueResourceBytes = new byte[lengthResource];
            System.arraycopy(this.bytes, offset += 2, valueResourceBytes, 0, lengthResource);
            String valueResource = new String(valueResourceBytes);
            offset += lengthResource;
            switch (typeResource) {
                case 1: {
                    this.nodeId = valueResource;
                    continue block7;
                }
                case 2: {
                    this.controllerIT = valueResource;
                    continue block7;
                }
                case 3: {
                    this.cpu = valueResource;
                    continue block7;
                }
                case 4: {
                    this.mem = valueResource;
                    continue block7;
                }
                case 5: {
                    this.storage = valueResource;
                }
            }
        }
    }

    protected int encodeHeaderSubTLV(int type, int valueLength, int byteStart) {
        this.bytes[byteStart] = (byte)(type >>> 8 & 0xFF);
        this.bytes[byteStart + 1] = (byte)(type & 0xFF);
        this.bytes[byteStart + 2] = (byte)(valueLength >>> 8 & 0xFF);
        this.bytes[byteStart + 3] = (byte)(valueLength & 0xFF);
        return byteStart + 4;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getMem() {
        return this.mem;
    }

    public void setMem(String mem) {
        this.mem = mem;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public String toString() {
        return "ITNodeNLRI [nodeID=" + this.nodeId + "controllerIT=" + this.controllerIT + ", cpu=" + this.cpu + ", mem=" + this.mem + ", storage=" + this.storage + "]";
    }

    public String getControllerIT() {
        return this.controllerIT;
    }

    public void setControllerIT(String controllerIT) {
        this.controllerIT = controllerIT;
    }
}

