/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.messages;

import es.tid.bgp.bgp4.messages.BGP4Message;
import es.tid.bgp.bgp4.open.BGP4CapabilitiesOptionalParameter;
import es.tid.bgp.bgp4.open.BGP4OptionalParameter;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class BGP4Open
extends BGP4Message {
    private int version = 4;
    private int myAutonomousSystem;
    private int holdTime = 3;
    private Inet4Address BGPIdentifier;
    private LinkedList<BGP4OptionalParameter> parametersList;

    public BGP4Open() {
        this.setMessageType(1);
        this.parametersList = new LinkedList();
    }

    public BGP4Open(byte[] bytes) {
        super(bytes);
        this.parametersList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = BGPHeaderLength + 10;
        int optionalParameterLength = 0;
        int num_parameters = this.parametersList.size();
        for (int i = 0; i < num_parameters; ++i) {
            BGP4OptionalParameter bgp4OptionalParameter = this.parametersList.get(i);
            bgp4OptionalParameter.encode();
            len += this.parametersList.get(i).getLength();
            optionalParameterLength += this.parametersList.get(i).getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = BGPHeaderLength;
        this.messageBytes[offset] = (byte)(this.version & 0xFF);
        this.messageBytes[++offset] = (byte)(this.myAutonomousSystem >>> 8 & 0xFF);
        this.messageBytes[offset + 1] = (byte)(this.myAutonomousSystem & 0xFF);
        this.messageBytes[offset += 2] = (byte)(this.holdTime >>> 8 & 0xFF);
        this.messageBytes[offset + 1] = (byte)(this.holdTime & 0xFF);
        System.arraycopy(this.BGPIdentifier.getAddress(), 0, this.messageBytes, offset += 2, 4);
        this.messageBytes[offset += 4] = (byte)(optionalParameterLength & 0xFF);
        ++offset;
        for (int i = 0; i < this.parametersList.size(); ++i) {
            System.arraycopy(this.parametersList.get(i).getBytes(), 0, this.messageBytes, offset, this.parametersList.get(i).getLength());
            offset += this.parametersList.get(i).getLength();
        }
    }

    public void decode() {
        int offset = BGPHeaderLength;
        int optionalParameterLength = 0;
        this.version = this.messageBytes[offset] & 0xFF;
        this.myAutonomousSystem = this.messageBytes[++offset] << 8 & 0xFF00 | this.messageBytes[offset + 1] & 0xFF;
        this.holdTime = this.messageBytes[offset += 2] << 8 & 0xFF00 | this.messageBytes[offset + 1] & 0xFF;
        byte[] ip = new byte[4];
        System.arraycopy(this.messageBytes, offset += 2, ip, 0, 4);
        try {
            this.BGPIdentifier = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        optionalParameterLength = this.messageBytes[offset += 4] & 0xFF;
        ++offset;
        if (optionalParameterLength != 0) {
            int parameterLength;
            for (int len = 0; len < optionalParameterLength; len += parameterLength) {
                int optionalParameterType = BGP4OptionalParameter.getType(this.messageBytes, offset);
                parameterLength = BGP4OptionalParameter.getLength(this.messageBytes, offset);
                if (optionalParameterType == 2) {
                    BGP4CapabilitiesOptionalParameter cop = new BGP4CapabilitiesOptionalParameter(this.getBytes(), offset);
                    this.parametersList.add(cop);
                }
                offset += parameterLength;
            }
        }
        if (offset > this.getLength()) {
            log.warn("Empty BGP OPEN message");
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMyAutonomousSystem() {
        return this.myAutonomousSystem;
    }

    public void setMyAutonomousSystem(int myAutonomousSystem) {
        this.myAutonomousSystem = myAutonomousSystem;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public Inet4Address getBGPIdentifier() {
        return this.BGPIdentifier;
    }

    public void setBGPIdentifier(Inet4Address bGPIdentifier) {
        this.BGPIdentifier = bGPIdentifier;
    }

    public LinkedList<BGP4OptionalParameter> getParametersList() {
        return this.parametersList;
    }

    public void setParametersList(LinkedList<BGP4OptionalParameter> parametersList) {
        this.parametersList = parametersList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.BGPIdentifier == null ? 0 : this.BGPIdentifier.hashCode());
        result = 31 * result + this.holdTime;
        result = 31 * result + this.myAutonomousSystem;
        result = 31 * result + (this.parametersList == null ? 0 : this.parametersList.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BGP4Open other = (BGP4Open)obj;
        if (this.BGPIdentifier == null ? other.BGPIdentifier != null : !this.BGPIdentifier.equals(other.BGPIdentifier)) {
            return false;
        }
        if (this.holdTime != other.holdTime) {
            return false;
        }
        if (this.myAutonomousSystem != other.myAutonomousSystem) {
            return false;
        }
        if (this.parametersList == null ? other.parametersList != null : !this.parametersList.equals(other.parametersList)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(8000);
        sb.append("BGP Open Message: \n");
        sb.append("> Version: " + this.version + "\n");
        sb.append("> MyAutonomousSystem: " + this.myAutonomousSystem + "\n");
        sb.append("> HoldTime: " + this.holdTime + "\n");
        sb.append("> BGPIdentifier: " + this.BGPIdentifier + "\n");
        if (this.parametersList != null) {
            for (int i = 0; i < this.parametersList.size(); ++i) {
                sb.append("> " + this.parametersList.get(i).toString() + "\n");
            }
        }
        return sb.toString();
    }
}

